package cn.tworice.system.controller.user;

import cn.tworice.auth.util.LoginUserUtil;
import cn.tworice.common.util.excel.ExcelUtil;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.conifg.LoginProperties;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.system.service.user.UserService;
import com.alibaba.excel.EasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;

@RestController
@RequestMapping("admin/admin")
@Slf4j
@CrossOrigin
@Api(tags = "系统账号管理")
@Log(table = "system_user")
public class UserController {

    @Resource
    private UserService service;

    @Resource
    private LoginProperties loginProperties;

    @GetMapping("list")
    @ApiOperation(value = "获取人员列表")
    public RequestResult list(PageParam pageParam, UserDO entity) {
        return RequestResult.success()
                .setData(service.getPage(pageParam, entity));
    }

    @PostMapping("add")
    @ApiOperation(value = "添加或更新人员账号")
    public RequestResult add(UserDO user) {
        service.updateOrInsert(user);
        return RequestResult.success("人员账号更新");
    }

    @DeleteMapping("del")
    @ApiOperation("删除人员账号")
    public RequestResult del(@RequestParam(name = "ids") String[] ids) {
        service.delAdminByIds(ids);
        return RequestResult.success("删除账号成功");
    }

    @PutMapping("update")
    @ApiOperation("更新账号密码")
    public RequestResult update(UserDO user) {
        if (service.updatePwd(user.getId(), user.getPassWord())) {
            return RequestResult.success().appendData("status", true);
        }
        return RequestResult.error("密码更新失败");
    }

    @PostMapping("inducts")
    @ApiOperation("通过Excel表格批量上传数据")
    public RequestResult inducts(MultipartFile file) {
        try (InputStream inputStream = file.getInputStream()) {
            EasyExcel.read(inputStream, UserDO.class, new InductsListener(service)).sheet().doRead();
            return RequestResult.success("批量导入数据成功");
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping("template")
    @ApiOperation("获取Excel模板")
    public void template(HttpServletResponse response) throws IOException {
        ExcelUtil.exportExcelTemplate(response, UserDO.class);
    }

    @GetMapping("info")
    @ApiOperation("通过ID获取数据")
    public RequestResult info(String id) {
        return RequestResult.success()
                .appendData("info", service.getInfo(id));
    }

    @PutMapping("rePassWord")
    @ApiOperation("重置账户密码")
    public RequestResult rePassWord(@ApiParam(required = true) String id) {
        if (service.rePassWord(id)) {
            return RequestResult.success(201, "重置密码为：" + loginProperties.getDefaultPassWord());
        } else {
            return RequestResult.error("重置密码失败");
        }
    }

    @PutMapping("reBindEmail")
    @ApiOperation("换绑邮箱")
    public RequestResult reBindEmail(String newEmail, String authCode) {
        service.updateBindEmail(newEmail, authCode);
        return RequestResult.success(201, "已更新账号邮箱");
    }

    @PostMapping("reEmailCaptcha")
    @ApiOperation("获取换绑邮箱验证码")
    public RequestResult reEmailCaptcha(String email) {
        service.sendAuthEmail(email);
        return RequestResult.success("验证码已发送");
    }

    @PutMapping("invite")
    @ApiOperation("获取邀请码")
    public RequestResult inviteCode() {
        return RequestResult.success().appendData("inviteCode", service.getInviteCode());
    }

    @GetMapping("inviteUser")
    @ApiOperation("获取当前用户邀请列表")
    public RequestResult inviteUser(PageParam pageParam) {
        return RequestResult
                .success()
                .setData(service.getUsersByInviterId(pageParam, LoginUserUtil.getLoginUserId()));
    }

    @PutMapping("updateLoginName")
    @ApiOperation("更新用户登录名")
    public RequestResult updateLoginName(String id, String loginName) {
        service.editLoginName(id, loginName);
        return RequestResult.success("更新成功");
    }
}
