package cn.tworice.system.service.user;



import cn.tworice.common.framework.mail.bo.SendMailBO;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.common.util.excel.InductsListenerService;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Map;

public interface UserService extends InductsListenerService<UserDO>, IService<UserDO> {

    Map<String,Object> getPage(PageParam pageParam, UserDO entity);

    String updateOrInsert(UserDO user);

    void delAdminByIds(String[] ids);

    boolean updatePwd(String id,String pwd);

    UserDO getInfo(String id);

    boolean rePassWord(String id);

    Map<String,Object> getUsersByRole(PageParam pageParam,Integer roleId);

    List<UserDO> getUsersByDepartmentId(Integer departmentId);

    List<UserDO> getUsersByNoDepartmentId(Integer departmentId);

    List<UserDO> getUsersByState(Integer status);

    UserDO getUserByEmailAndPwd(String email, String password);

    UserDO getUser(String loginName);

    void updateBindEmail(String newEmail,String authCode);

    void sendAuthEmail(String email);

    String getInviteCode();

    String getUserIdByInviteCode(String inviteCode);

    Map<String,Object> getUsersByInviterId(PageParam pageParam, String inviterId);

    UserDO existUserByEmail(String email);

    UserDO existUserByPhone(String phone);

    void editLoginName(String id,String loginName);

    UserDO getUserByNameAndPwd(String loginName, String password);

    UserDO getUserByPhoneAndPwd(String phone, String password);

    UserDO getUserByIDAndPwd(String id, String password);

    void batchSendEmail(List<String> userId, String subject, String content);

}
