/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.wechat.utils;

import cn.tworice.common.util.StringUtils;
import cn.tworice.wechat.constant.WeChatConstant;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WeChatUtil {
    private static final Logger log = LoggerFactory.getLogger(WeChatUtil.class);

    public static JSONObject getOpenIdByCode(String code, String appid, String appSecret) {
        StringBuilder url = new StringBuilder("https://api.weixin.qq.com/sns/jscode2session?appid=").append(appid).append("&secret=").append(appSecret).append("&js_code=").append(code).append("&grant_type=authorization_code");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url.toString());
        InputStream inputStream = null;
        CloseableHttpResponse httpResponse = null;
        StringBuilder result = new StringBuilder();
        String openId = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            inputStream = entity.getContent();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            line = bufferedReader.readLine();
            if (line != null) {
                JSONObject jsonObject = JSON.parseObject((String)line);
                log.debug("jsonObject{}", (Object)jsonObject);
                openId = jsonObject.getString("openid");
                String sessionKey = jsonObject.getString("session_key");
                log.debug("openId={},sessionKey={}", (Object)openId, (Object)sessionKey);
                return jsonObject;
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6openId\u5931\u8d25" + e.getMessage());
        }
        return null;
    }

    public static String generateSignature1(Map<String, Object> data, String key) throws Exception {
        return WeChatUtil.generateSignature1(data, key, WeChatConstant.SignType.MD5);
    }

    public static String generateSignature1(Map<String, Object> data, String key, WeChatConstant.SignType signType) throws Exception {
        if (data.containsKey("sign")) {
            data.remove("sign");
        }
        data.put("key", key);
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || StringUtils.isEmpty((Object)data.get(k))) continue;
            sb.append((String)k).append("=").append(data.get(k)).append("&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (WeChatConstant.SignType.MD5.equals((Object)signType)) {
            return WeChatUtil.MD5(sb.toString()).toUpperCase();
        }
        if (WeChatConstant.SignType.HMACSHA256.equals((Object)signType)) {
            return WeChatUtil.HMACSHA256(sb.toString(), key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", new Object[]{signType}));
    }

    public static Map<String, String> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception ex) {
            log.warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)ex.getMessage(), (Object)strXML);
            throw ex;
        }
    }

    public static String mapToXml(Map<String, String> data) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element root = document.createElement("xml");
        document.appendChild(root);
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null) {
                value = "";
            }
            value = value.trim();
            Element filed = document.createElement(key);
            filed.appendChild(document.createTextNode(value));
            root.appendChild(filed);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        String output = writer.getBuffer().toString();
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public static String generateSignedXml(Map<String, String> data, String key) throws Exception {
        return WeChatUtil.generateSignedXml(data, key, WeChatConstant.SignType.MD5);
    }

    public static String generateSignedXml(Map<String, String> data, String key, WeChatConstant.SignType signType) throws Exception {
        String sign = WeChatUtil.generateSignature(data, key, signType);
        data.put("sign", sign);
        return WeChatUtil.mapToXml(data);
    }

    public static boolean isSignatureValid(String xmlStr, String key) throws Exception {
        Map<String, String> data = WeChatUtil.xmlToMap(xmlStr);
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = data.get("sign");
        return WeChatUtil.generateSignature(data, key).equals(sign);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key) throws Exception {
        return WeChatUtil.isSignatureValid(data, key, WeChatConstant.SignType.MD5);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key, WeChatConstant.SignType signType) throws Exception {
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = data.get("sign");
        return WeChatUtil.generateSignature(data, key, signType).equals(sign);
    }

    public static String generateSignature(Map<String, String> data, String key) throws Exception {
        return WeChatUtil.generateSignature(data, key, WeChatConstant.SignType.MD5);
    }

    public static String generateSignature(Map<String, String> data, String key, WeChatConstant.SignType signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || data.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(data.get(k).trim()).append("&");
        }
        sb.append("key=").append(key);
        if (WeChatConstant.SignType.MD5.equals((Object)signType)) {
            return WeChatUtil.MD5(sb.toString()).toUpperCase();
        }
        if (WeChatConstant.SignType.HMACSHA256.equals((Object)signType)) {
            return WeChatUtil.HMACSHA256(sb.toString(), key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", new Object[]{signType}));
    }

    public static String generateNonceStr() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32);
    }

    public static String MD5(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32);
    }
}

