/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.core;

import cn.tyoui.httpclient.HttpCrawler;
import cn.tyoui.proxy.CrawlerProxyIP;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ControllerCrawler {
    private Map<String, String> map = new HashMap<String, String>();
    private String dir = "c:\\crawler";
    private String url = "http://www.baidu.com";
    private int start = 0;
    private int end = 0;

    public void start() throws Exception {
        Properties properties = new Properties();
        InputStream in = this.getClass().getResourceAsStream("/crawler.properties");
        properties.load(in);
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            this.map.put(key.toLowerCase(), value);
        }
        in.close();
        this.initCrawler();
    }

    private void initCrawler() throws Exception {
        HttpCrawler httpCrawler = new HttpCrawler();
        String proxy = this.changer("isProxyIP", null);
        if (proxy != null) {
            boolean flag = Boolean.parseBoolean(this.changer("isFreeIP", "true"));
            if (flag) {
                CrawlerProxyIP crawlerProxyIP = new CrawlerProxyIP();
                int allNum = Integer.parseInt(this.changer("ProxyAllNum", "500")) / 100;
                int maxIp = Integer.parseInt(this.changer("MaxProxyIP", "100"));
                for (int i = 1; i <= allNum; ++i) {
                    String html = null;
                    try {
                        html = crawlerProxyIP.crawler("http://www.xicidaili.com/nn/" + i);
                        crawlerProxyIP.proxyRead(html);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                crawlerProxyIP.writeIP(maxIp);
                String path = new File("").getCanonicalPath() + File.separator + "text";
                httpCrawler.proxyInit(path + File.separator + "\u4ee3\u7406ip.txt");
            } else {
                String text = this.changer("oneselfProxyIPText", new File(".").getAbsolutePath());
                this.oneselfProxyIP(httpCrawler, text);
            }
        }
        int min = Integer.parseInt(this.changer("minTime", "10"));
        int max = Integer.parseInt(this.changer("maxTime", "50")) - min;
        this.url = this.changer("URL", this.url);
        this.dir = this.changer("CrawlerHtmlDir", this.dir);
        httpCrawler.setDir(this.dir);
        String joinEnd = this.changer("endIndex", null);
        if (joinEnd != null) {
            this.end = Integer.parseInt(joinEnd);
            this.start = Integer.parseInt(this.changer("startIndex", "0"));
            String URLPrefix = this.changer("URLPrefix", "");
            String URLSuffix = this.changer("URLSuffix", "");
            for (int i = this.start; i < this.end; ++i) {
                httpCrawler.startCrawler(this.url + URLPrefix + i + URLSuffix, min, max);
            }
        } else {
            httpCrawler.startCrawler(this.url, min, max);
        }
        httpCrawler.close();
    }

    private String changer(String key, String values) {
        String value = this.map.get(key.toLowerCase());
        if (value != null) {
            return value;
        }
        return values;
    }

    private void oneselfProxyIP(HttpCrawler httpCrawler, String textIP) {
        try {
            httpCrawler.proxyInit(textIP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

