/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.proxy;

import cn.tyoui.pojo.ProxyIP;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CrawlerProxyIP {
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private List<ProxyIP> list = new ArrayList<ProxyIP>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String crawler(String url) throws Exception {
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        String text = null;
        try {
            httpGet = new HttpGet(url);
            httpGet.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            httpGet.setHeader("Accept-Encoding", "gzip,deflate,sdch");
            httpGet.setHeader("Accept-Language", "zh-CN,zh;q=0.8");
            httpGet.setHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36");
            RequestConfig requestConfig = RequestConfig.custom().build();
            httpGet.setConfig(requestConfig);
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            text = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception exception) {
        }
        finally {
            if (httpGet != null) {
                httpGet.clone();
            }
            if (response != null) {
                response.close();
            }
        }
        return text;
    }

    public void proxyRead(String html) {
        try {
            Document document = Jsoup.parse((String)html);
            Elements elements = document.select("tr");
            for (int i = 1; i < elements.size(); ++i) {
                String[] ip = ((Element)elements.get(i)).text().split(" ");
                ProxyIP proxyIP = new ProxyIP(ip[0], Integer.parseInt(ip[1]));
                String speed = ((Element)elements.get(i)).select(".bar_inner").attr("style");
                speed = speed.substring(6, speed.length() - 1);
                proxyIP.setIPSpeed(speed);
                this.list.add(proxyIP);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeIP(int maxIp) {
        try {
            String path = new File("").getCanonicalPath() + File.separator + "text";
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            path = path + File.separator + "ip.txt";
            Collections.sort(this.list, Comparator.comparing(ProxyIP::getIPSpeed, Comparator.reverseOrder()));
            FileUtils.writeLines((File)new File(path), this.list.subList(0, maxIp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void htmlListIP(String text, String split) {
        if (text != null) {
            String[] html;
            for (String ip : html = text.split(split)) {
                String[] ipPort = ip.split(":");
                if (ipPort.length != 2) continue;
                this.list.add(new ProxyIP(ipPort[0], Integer.parseInt(ipPort[1])));
            }
        }
    }
}

