package cn.tyoui.core;

/**
 * 线程类
 *
 * @author tyoui
 * @version 1.8.4
 */
public class Crawler implements Runnable {

    private int start, end;

    private void setThread(int start, int end) {
        this.start = start;
        this.end = end;
    }


    /**
     * 启动线程
     */
    @Override
    public void run() {
        ControllerCrawler controllerCrawler = new ControllerCrawler();
        try {
            controllerCrawler.setThread(start, end);
            controllerCrawler.start();
            controllerCrawler.initCrawler();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 开始启动多线程
     *
     * @throws Exception 启动失败
     */
    public void start() throws Exception {
        ControllerCrawler controllerCrawler = new ControllerCrawler();
        controllerCrawler.setThread(1, 2);
        controllerCrawler.start();
        int start = Integer.parseInt(controllerCrawler.changer("startIndex", "" + 0));
        int end = Integer.parseInt(controllerCrawler.changer("endIndex", "" + 0));
        int threadNum = Integer.parseInt(controllerCrawler.changer("ThreadNum", "" + 1));
        int loop = end / threadNum;
        for (int i = 0; i < threadNum; i++) {
            Crawler crawlerThread = new Crawler();
            crawlerThread.setThread(start + i * loop, start + loop * (i + 1));
            Thread thread = new Thread(crawlerThread);
            thread.start();
            System.out.println("这是第" + i + "个线程启动");
        }
    }

}
