/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.core;

import cn.tyoui.httpclient.HttpCrawler;
import cn.tyoui.pojo.ProxyIP;
import cn.tyoui.proxy.CrawlerProxyIP;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ControllerCrawler {
    private Map<String, String> map = new HashMap<String, String>();
    private String dir = "c:\\crawler";
    private String url = "http://www.baidu.com";
    private int threadStart;
    private int threadEnd;

    public void start() throws Exception {
        Properties properties = new Properties();
        InputStream in = this.getClass().getResourceAsStream("/crawler.properties");
        properties.load(in);
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            this.map.put(key.toLowerCase(), value);
        }
        in.close();
        if (this.threadEnd == 0 && this.threadStart == 0) {
            this.initCrawler();
        }
    }

    public void initCrawler() throws Exception {
        HttpCrawler httpCrawler = new HttpCrawler();
        CrawlerProxyIP crawlerProxyIP = new CrawlerProxyIP();
        String proxy = this.changer("isProxyIP", null);
        if (proxy != null) {
            boolean flag = Boolean.parseBoolean(this.changer("isFreeIP", "true"));
            if (flag) {
                int allNum = Integer.parseInt(this.changer("ProxyAllNum", "500")) / 100;
                int maxIp = Integer.parseInt(this.changer("MaxProxyIP", "100"));
                for (int i = 1; i <= allNum; ++i) {
                    try {
                        String html = crawlerProxyIP.crawler("http://www.xicidaili.com/nn/" + i);
                        crawlerProxyIP.proxyRead(html);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                crawlerProxyIP.writeIP(maxIp);
                String path = new File("").getCanonicalPath() + File.separator + "text";
                httpCrawler.proxyInit(path + File.separator + "ip.txt");
            } else if (this.changer("ProxyIpAPI", null) != null) {
                String url = this.changer("ProxyIpAPI", null);
                String html = crawlerProxyIP.crawler(url);
                List<ProxyIP> list = crawlerProxyIP.htmlListIP(html, this.changer("apiSplit", "\n"));
                httpCrawler.setList(list);
            } else {
                String text = this.changer("oneselfProxyIPText", new File(".").getAbsolutePath());
                this.oneselfProxyIP(httpCrawler, text);
            }
        }
        int min = Integer.parseInt(this.changer("minTime", "0"));
        int max = Integer.parseInt(this.changer("maxTime", "0")) - min;
        this.url = this.changer("URL", this.url);
        this.dir = this.changer("CrawlerHtmlDir", this.dir);
        httpCrawler.setDir(this.dir);
        String joinEnd = this.changer("endIndex", null);
        if (joinEnd != null) {
            int end = Integer.parseInt(joinEnd);
            int start = Integer.parseInt(this.changer("startIndex", "0"));
            String URLPrefix = this.changer("URLPrefix", "");
            String URLSuffix = this.changer("URLSuffix", "");
            if (this.threadStart == 0 && this.threadEnd == 0) {
                for (int i = start; i < end; ++i) {
                    httpCrawler.startCrawler(this.url + URLPrefix + i + URLSuffix, min, max);
                }
            } else {
                for (int i = this.threadStart; i < this.threadEnd; ++i) {
                    httpCrawler.startCrawler(this.url + URLPrefix + i + URLSuffix, min, max);
                }
            }
        } else {
            httpCrawler.startCrawler(this.url, min, max);
        }
        httpCrawler.close();
    }

    public String changer(String key, String values) {
        String value = this.map.get(key.toLowerCase());
        if (value != null) {
            return value;
        }
        return values;
    }

    private void oneselfProxyIP(HttpCrawler httpCrawler, String textIP) {
        try {
            httpCrawler.proxyInit(textIP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setThread(int start, int end) {
        this.threadStart = start;
        this.threadEnd = end;
    }
}

