/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.dt;

import cn.tyoui.dt.ID3;
import cn.tyoui.dt.Tree;
import cn.tyoui.exception.LogException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DT {
    private Logger logger = Logger.getLogger(DT.class);
    private String[][] data;
    private ID3 id3 = new ID3();
    private int INDEX;

    public List<String[]> getDataFile(String file) throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while (bufferedReader.ready()) {
            String[] line = bufferedReader.readLine().split("\t");
            list.add(line);
        }
        bufferedReader.close();
        inputStream.close();
        return list;
    }

    public Map<Integer, Map<String, Integer[]>> category(String[][] arrays) {
        HashMap<Integer, Map<String, Integer[]>> mapMap = new HashMap<Integer, Map<String, Integer[]>>();
        int horizontal = arrays.length;
        int vertical = arrays[1].length;
        for (int j = 0; j < vertical; ++j) {
            HashMap<String, Map<String, Integer>> categoryMap = new HashMap<String, Map<String, Integer>>();
            HashMap<String, Integer[]> map = new HashMap<String, Integer[]>();
            for (int i = 0; i < horizontal; ++i) {
                Map<String, Integer> m;
                String key = arrays[i][j];
                if (j == this.INDEX) {
                    Integer[] values;
                    if (map.get(key) == null) {
                        map.put(key, new Integer[]{1});
                        continue;
                    }
                    Integer[] integerArray = values = (Integer[])map.get(key);
                    Integer n = integerArray[0];
                    integerArray[0] = integerArray[0] + 1;
                    Integer n2 = integerArray[0];
                    map.put(key, values);
                    continue;
                }
                if (categoryMap.get(key) == null) {
                    m = new HashMap<String, Integer>();
                    m.put(arrays[i][this.INDEX], 1);
                    categoryMap.put(key, m);
                    continue;
                }
                m = (Map)categoryMap.get(key);
                if (m.containsKey(arrays[i][this.INDEX])) {
                    m.replace(arrays[i][this.INDEX], (Integer)m.get(arrays[i][this.INDEX]) + 1);
                } else {
                    m.put(arrays[i][this.INDEX], 1);
                }
                categoryMap.replace(key, m);
            }
            if (j != this.INDEX) {
                map = new HashMap();
                for (String key : categoryMap.keySet()) {
                    Map integers = (Map)categoryMap.get(key);
                    Integer[] values = new Integer[integers.size()];
                    int index = 0;
                    for (String k : integers.keySet()) {
                        values[index++] = (Integer)integers.get(k);
                    }
                    map.put(key, values);
                }
            }
            mapMap.put(j, map);
        }
        return mapMap;
    }

    public String[][] listArrays(List<String[]> list) {
        String[][] data = new String[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            data[i] = list.get(i);
        }
        return data;
    }

    public Map<Integer, Double> group() throws LogException {
        Map<Integer, Map<String, Integer[]>> category = this.category(this.data);
        Map<String, Integer[]> infoMap = category.get(this.INDEX);
        Integer[] INFO_D = new Integer[infoMap.size()];
        int index = 0;
        for (Integer[] integers : infoMap.values()) {
            INFO_D[index++] = integers[0];
        }
        double info = this.id3.Info_D(INFO_D);
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (Integer key : category.keySet()) {
            double entropy = 0.0;
            if (key == this.INDEX) continue;
            Map<String, Integer[]> integers = category.get(key);
            for (Integer[] values : integers.values()) {
                entropy += this.id3.Info_A(this.data.length, values);
            }
            entropy = this.id3.Gain(info, entropy);
            map.put(key, entropy);
        }
        return map;
    }

    public void readerData(String file) {
        try {
            this.data = this.listArrays(this.getDataFile(file));
            this.INDEX = this.data[0].length - 1;
        }
        catch (Exception e) {
            this.logger.error((Object)"\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38");
        }
    }

    public Integer maxEntropy(Map<Integer, Double> map) {
        double Max = 0.0;
        Integer flag = 0;
        for (Integer key : map.keySet()) {
            double value = map.get(key);
            if (!(value > Max)) continue;
            Max = value;
            flag = key;
        }
        return flag;
    }

    public Map<String, Integer> treeNode(Integer head) {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (int i = 0; i < this.data.length; ++i) {
            String key = this.data[i][head];
            if (values.get(key) == null) {
                values.put(key, 1);
                continue;
            }
            values.replace(key, (Integer)values.get(key) + 1);
        }
        return values;
    }

    public Map<String, String[][]> createTree(Integer head) {
        HashMap<String, String[][]> map = new HashMap<String, String[][]>();
        Map<String, Integer> values = this.treeNode(head);
        for (int i = 0; i < this.data.length; ++i) {
            String[][] s;
            String key = this.data[i][head];
            if (map.get(key) == null) {
                s = new String[values.get(key).intValue()][this.data[i].length - 1];
                int index = 0;
                for (int j = 0; j < this.data[i].length; ++j) {
                    if (j == head) continue;
                    s[0][index] = this.data[i][j];
                    ++index;
                }
            } else {
                s = (String[][])map.get(key);
                Integer row = 0;
                int flag = head == 0 ? head + 1 : head - 1;
                for (String[] k : s) {
                    if (k[flag] == null) continue;
                    Integer n = row;
                    Integer n2 = row = Integer.valueOf(row + 1);
                }
                int index = 0;
                for (int j = 0; j < this.data[i].length; ++j) {
                    if (j == head) continue;
                    s[row.intValue()][index] = this.data[i][j];
                    ++index;
                }
            }
            map.put(key, s);
        }
        return map;
    }

    public void printData(String[][] data) {
        String[][] stringArray = data;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] str;
            for (String value : str = stringArray[i]) {
                System.out.print("\t" + value + "\t");
            }
            System.out.println();
        }
    }

    public void rewriteData(String[][] data) {
        this.data = data;
        this.INDEX = data[0].length - 1;
    }

    public void loopTree(Tree tree) throws LogException {
        Map<Integer, Double> group = this.group();
        Integer head = this.maxEntropy(group);
        Map<String, String[][]> map = this.createTree(head);
        for (String key : map.keySet()) {
            Tree tr = new Tree();
            tr.attribute = key;
            tr.data = map.get(key);
            tree.children.add(tr);
            if (tr.data.length == 1) continue;
            this.rewriteData(tr.data);
            this.loopTree(tree);
        }
    }

    public void writeTree(Tree tree, String filePath) {
        FileWriter writer;
        File file = new File(filePath);
        try {
            writer = new FileWriter(file, true);
        }
        catch (IOException e) {
            this.logger.error((Object)"\u6587\u4ef6\u540d\u6709\u95ee\u9898\u6216\u8005\u6539\u6587\u4ef6\u4e0d\u53ef\u6253\u5f00");
            return;
        }
        for (Tree trees : tree.children) {
            StringBuilder text = new StringBuilder();
            String[][] data = trees.data;
            text.append("\u5c5e\u6027:" + trees.attribute + "\n");
            String[][] stringArray = data;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] str;
                for (String value : str = stringArray[i]) {
                    text.append("\t" + value + "\t");
                }
                text.append("\n");
            }
            try {
                writer.write(text.toString());
            }
            catch (IOException e) {
                this.logger.error((Object)"\u6587\u4ef6\u5199\u5165\u5f02\u5e38");
            }
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException e) {
            this.logger.error((Object)"\u6587\u4ef6\u5173\u95ed\u5931\u8d25");
        }
    }
}

