/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.nbc;

import cn.tyoui.dt.DT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NBC {
    private Logger logger = Logger.getLogger(NBC.class);
    private String[][] data;
    private Integer INDEX;
    private Map<Integer, Double> continual = new HashMap<Integer, Double>();

    public NBC() {
    }

    public NBC(Integer INDEX) {
        this.INDEX = INDEX;
    }

    public String[][] readArrayFile(String file) throws Exception {
        DT dt = new DT();
        List<String[]> list = dt.getDataFile(file);
        this.data = dt.listArrays(list);
        this.INDEX = this.data[0].length - 1;
        return this.data;
    }

    public Map<String, Integer> eigenvalue(int index) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.data.length; ++i) {
            String key = this.data[i][index];
            if (map.get(key) == null) {
                map.put(key, 1);
                continue;
            }
            map.replace(key, (Integer)map.get(key) + 1);
        }
        return map;
    }

    public Map<String, Double> numerator(String key, Integer value, int row) {
        int i;
        HashMap<String, Double> map = new HashMap<String, Double>();
        double average = 0.0;
        double variance = 0.0;
        for (i = 0; i < this.data.length; ++i) {
            if (!this.data[i][this.INDEX].equals(key)) continue;
            String eigenvalue = this.data[i][row];
            if (this.continual.get(row) != null) {
                average += Double.parseDouble(eigenvalue);
                continue;
            }
            if (map.get(eigenvalue) == null) {
                map.put(eigenvalue, 1.0 / (double)value.intValue());
                continue;
            }
            map.replace(eigenvalue, (Double)map.get(eigenvalue) + 1.0 / (double)value.intValue());
        }
        if (this.continual.get(row) != null) {
            average /= (double)value.intValue();
            for (i = 0; i < this.data.length; ++i) {
                if (!this.data[i][this.INDEX].equals(key)) continue;
                variance += Math.pow(Double.parseDouble(this.data[i][row]) - average, 2.0);
            }
            map.put("" + this.continual.get(row), this.ND(average, variance /= (double)value.intValue(), this.continual.get(row)));
        }
        return map;
    }

    public Map<String, Double> denominator(int row) {
        int i;
        double average = 0.0;
        double variance = 0.0;
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (i = 0; i < this.data.length; ++i) {
            String eigenvalue = this.data[i][row];
            if (this.continual.get(row) != null) {
                average += Double.parseDouble(this.data[i][row]);
                continue;
            }
            if (map.get(eigenvalue) == null) {
                map.put(eigenvalue, 1.0 / (double)this.data.length);
                continue;
            }
            map.replace(eigenvalue, (Double)map.get(eigenvalue) + 1.0 / (double)this.data.length);
        }
        if (this.continual.get(row) != null) {
            average /= (double)this.data.length;
            for (i = 0; i < this.data.length; ++i) {
                variance += Math.pow(Double.parseDouble(this.data[i][row]) - average, 2.0);
            }
            map.put("" + this.continual.get(row), this.ND(average, variance /= (double)this.data.length, this.continual.get(row)));
        }
        return map;
    }

    public double start(String ... print) {
        if (print == null) {
            this.logger.error((Object)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
            return 0.0;
        }
        String key = print[this.INDEX];
        double numeratorAll = 1.0;
        double denominatorAll = 1.0;
        Map<String, Integer> map = this.eigenvalue(this.INDEX);
        if (map.get(key) == null) {
            this.logger.error((Object)"\u7279\u5f81\u503c\u627e\u4e0d\u5230\u3002\u8f93\u5165\u6709\u95ee\u9898!");
            return 0.0;
        }
        double eigenvalueAll = (double)map.get(key).intValue() * 1.0 / (double)this.data.length;
        for (int row = 0; row < this.data[0].length - 1; ++row) {
            Map<String, Double> numerator = this.numerator(key, map.get(key), row);
            Map<String, Double> denominator = this.denominator(row);
            denominatorAll *= denominator.get(print[row]).doubleValue();
            Double n = numerator.get(print[row]);
            if (n == null) {
                this.logger.error((Object)"\u524d\u63d0\u6761\u4ef6\u9519\u8bef!");
                return 0.0;
            }
            numeratorAll *= n.doubleValue();
        }
        return numeratorAll * eigenvalueAll / denominatorAll;
    }

    public List<String> eigenvalue() {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, Integer> eigenvalue = this.eigenvalue(this.INDEX);
        for (String key : eigenvalue.keySet()) {
            list.add(key);
        }
        return list;
    }

    public void setRowContinual(Integer row, Double value) {
        this.continual.put(row, value);
    }

    private double ND(double average, double variance, double x) {
        double foot = 1.0 / Math.sqrt(Math.PI * 2 * variance);
        double head = Math.pow(average - x, 2.0) / (2.0 * variance);
        double pro = foot * Math.pow(Math.E, -head);
        return pro;
    }
}

