/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.analyzerImpl;

import cn.tyoui.Ianalyzer.IAnalysis;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class AnalysisImpl
implements IAnalysis {
    static Logger log = Logger.getLogger(AnalysisImpl.class);

    @Override
    public List<String> participle(String text, boolean intelligent) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IKAnalyzer analyzer = new IKAnalyzer(intelligent);
            TokenStream tokenStream = analyzer.tokenStream("title", text);
            tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                CharTermAttribute termAttribute = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                String work = termAttribute.toString();
                if (work.length() <= 1) continue;
                list.add(work);
            }
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
        return list;
    }

    @Override
    public String socket(Socket socket) throws Exception {
        log.info((Object)("\u8fde\u63a5\u5df2\u5efa\u7acb\u3002\u7aef\u53e3\u53f7\uff1a" + socket.getPort()));
        Scanner scanner = new Scanner(socket.getInputStream());
        String text = "";
        if (scanner.hasNext()) {
            text = scanner.nextLine();
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessageURL(Socket socket, String text) throws Exception {
        PrintStream out = null;
        try {
            out = new PrintStream(socket.getOutputStream());
            out.println("HTTP/1.1 200 OK");
            out.println("Content-type: application/json;");
            out.println();
            out.println(text);
            out.flush();
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }
}

