/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.geolocation.composer.impl;

import cn.unikue.commonplexus.javaseutil.util.InetAddressWraps;
import cn.unikue.springstarter.geolocation.composer.GeoLocationResolver;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.WebServiceClient;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultGeoLocationResolver
implements GeoLocationResolver {
    private DatabaseReader countryReader;
    private DatabaseReader cityReader;
    private WebServiceClient webClient;
    private boolean discardLan;

    @Override
    public String getCompositeAddress(@Nullable String ipAddress) throws IOException, GeoIp2Exception {
        return this.getCompositeAddress(ipAddress, (Locale)null);
    }

    @Override
    public String getCompositeAddress(@Nullable String ipAddress, @Nullable Locale locale) throws IOException, GeoIp2Exception {
        return this.getCompositeAddress(ipAddress, '/', locale);
    }

    @Override
    public String getCompositeAddress(@Nullable String ipAddress, char delimiter) throws IOException, GeoIp2Exception {
        return this.getCompositeAddress(ipAddress, delimiter, null);
    }

    @Override
    public String getCompositeAddress(@Nullable String ipAddress, char delimiter, @Nullable Locale locale) throws IOException, GeoIp2Exception {
        return this.getCompositeAddress(ipAddress, CharUtils.toString((char)delimiter), locale);
    }

    @Override
    public String getCompositeAddress(@Nullable String ipAddress, @Nullable String delimiter) throws IOException, GeoIp2Exception {
        return this.getCompositeAddress(ipAddress, delimiter, null);
    }

    @Override
    public String getCompositeAddress(@Nullable String ipAddress, @Nullable String delimiter, @Nullable Locale locale) throws IOException, GeoIp2Exception {
        Optional cityResponse;
        Optional countryResponse;
        if (StringUtils.isBlank((CharSequence)ipAddress) || this.discardLan && InetAddressWraps.isLanAddress((String)ipAddress) || ObjectUtils.allNull((Object[])new Object[]{this.countryReader, this.cityReader, this.webClient})) {
            return null;
        }
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        String countryName = null;
        String cityName = null;
        if (this.countryReader != null && (countryResponse = this.countryReader.tryCountry(inetAddress)) != null && countryResponse.isPresent()) {
            countryName = this.getLocalizedCountryName((CountryResponse)countryResponse.get(), locale);
        }
        if (this.cityReader != null && (cityResponse = this.cityReader.tryCity(inetAddress)) != null && cityResponse.isPresent()) {
            cityName = this.getLocalizedCityName((CityResponse)cityResponse.get(), locale);
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{this.countryReader, this.cityReader})) {
            return StringUtils.isAllBlank((CharSequence[])new CharSequence[]{countryName, cityName}) ? null : StringUtils.joinWith((String)StringUtils.defaultString((String)delimiter), (Object[])new Object[]{countryName, cityName});
        }
        if (this.webClient != null) {
            CityResponse cityResponse2;
            countryResponse = this.webClient.country(inetAddress);
            if (countryResponse != null) {
                countryName = this.getLocalizedCountryName((CountryResponse)countryResponse, locale);
            }
            if ((cityResponse2 = this.webClient.city(inetAddress)) != null) {
                cityName = this.getLocalizedCityName(cityResponse2, locale);
            }
            return StringUtils.isAllBlank((CharSequence[])new CharSequence[]{countryName, cityName}) ? null : StringUtils.joinWith((String)StringUtils.defaultString((String)delimiter), (Object[])new Object[]{countryName, cityName});
        }
        return null;
    }

    @Override
    public String getCompositeAddressQuietly(@Nullable String ipAddress) {
        return this.getCompositeAddressQuietly(ipAddress, (Locale)null);
    }

    @Override
    public String getCompositeAddressQuietly(@Nullable String ipAddress, @Nullable Locale locale) {
        return this.getCompositeAddressQuietly(ipAddress, '/', locale);
    }

    @Override
    public String getCompositeAddressQuietly(@Nullable String ipAddress, char delimiter) {
        return this.getCompositeAddressQuietly(ipAddress, delimiter, null);
    }

    @Override
    public String getCompositeAddressQuietly(@Nullable String ipAddress, char delimiter, @Nullable Locale locale) {
        return this.getCompositeAddressQuietly(ipAddress, CharUtils.toString((char)delimiter), locale);
    }

    @Override
    public String getCompositeAddressQuietly(@Nullable String ipAddress, @Nullable String delimiter) {
        return this.getCompositeAddressQuietly(ipAddress, delimiter, null);
    }

    @Override
    public String getCompositeAddressQuietly(@Nullable String ipAddress, @Nullable String delimiter, @Nullable Locale locale) {
        try {
            return this.getCompositeAddress(ipAddress, delimiter, locale);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getCountryName(@Nullable String ipAddress) throws IOException, GeoIp2Exception {
        return this.getCountryName(ipAddress, null);
    }

    @Override
    public String getCountryName(@Nullable String ipAddress, @Nullable Locale locale) throws IOException, GeoIp2Exception {
        Optional countryResponse;
        if (StringUtils.isBlank((CharSequence)ipAddress) || this.discardLan && InetAddressWraps.isLanAddress((String)ipAddress) || ObjectUtils.allNull((Object[])new Object[]{this.countryReader, this.webClient})) {
            return null;
        }
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        if (this.countryReader != null && (countryResponse = this.countryReader.tryCountry(inetAddress)) != null && countryResponse.isPresent()) {
            return this.getLocalizedCountryName((CountryResponse)countryResponse.get(), locale);
        }
        if (this.webClient != null) {
            countryResponse = this.webClient.country(inetAddress);
            return this.getLocalizedCountryName((CountryResponse)countryResponse, locale);
        }
        return null;
    }

    @Override
    public String getCountryNameQuietly(@Nullable String ipAddress) {
        return this.getCountryNameQuietly(ipAddress, null);
    }

    @Override
    public String getCountryNameQuietly(@Nullable String ipAddress, @Nullable Locale locale) {
        try {
            return this.getCountryName(ipAddress, locale);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getCityName(@Nullable String ipAddress) throws IOException, GeoIp2Exception {
        return this.getCityName(ipAddress, null);
    }

    @Override
    public String getCityName(@Nullable String ipAddress, @Nullable Locale locale) throws IOException, GeoIp2Exception {
        Optional cityResponse;
        if (StringUtils.isBlank((CharSequence)ipAddress) || this.discardLan && InetAddressWraps.isLanAddress((String)ipAddress) || ObjectUtils.allNull((Object[])new Object[]{this.cityReader, this.webClient})) {
            return null;
        }
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        if (this.cityReader != null && (cityResponse = this.cityReader.tryCity(inetAddress)) != null && cityResponse.isPresent()) {
            return this.getLocalizedCityName((CityResponse)cityResponse.get(), locale);
        }
        if (this.webClient != null) {
            cityResponse = this.webClient.city(inetAddress);
            return this.getLocalizedCityName((CityResponse)cityResponse, locale);
        }
        return null;
    }

    @Override
    public String getCityNameQuietly(@Nullable String ipAddress) {
        return this.getCityNameQuietly(ipAddress, null);
    }

    @Override
    public String getCityNameQuietly(@Nullable String ipAddress, @Nullable Locale locale) {
        try {
            return this.getCityName(ipAddress, locale);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private String getLocalizedCountryName(@Nullable CountryResponse response, @Nullable Locale locale) {
        if (response == null) {
            return null;
        }
        return locale == null ? response.getCountry().getName() : this.extractLocalizedName(response.getCountry().getNames(), locale);
    }

    @Nullable
    private String getLocalizedCityName(@Nullable CityResponse response, @Nullable Locale locale) {
        if (response == null) {
            return null;
        }
        return locale == null ? response.getCity().getName() : this.extractLocalizedName(response.getCity().getNames(), locale);
    }

    @Nullable
    private String extractLocalizedName(@Nullable Map<String, String> names, @Nonnull Locale locale) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        List lookups = LocaleUtils.localeLookupList((Locale)locale);
        for (Locale lookup : lookups) {
            if (!names.containsKey(lookup.toLanguageTag())) continue;
            return names.get(lookup.toLanguageTag());
        }
        return null;
    }

    @Generated
    public DefaultGeoLocationResolver(DatabaseReader countryReader, DatabaseReader cityReader, WebServiceClient webClient, boolean discardLan) {
        this.countryReader = countryReader;
        this.cityReader = cityReader;
        this.webClient = webClient;
        this.discardLan = discardLan;
    }
}

