/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.geolocation.config;

import cn.unikue.commonplexus.javaseutil.util.InetProxyWraps;
import cn.unikue.commonplexus.javaseutil.util.NumberUtilsWraps;
import cn.unikue.springstarter.geolocation.composer.GeoLocationResolver;
import cn.unikue.springstarter.geolocation.composer.impl.DefaultGeoLocationResolver;
import cn.unikue.springstarter.geolocation.enumeration.GeoDatabaseType;
import cn.unikue.springstarter.geolocation.property.GeoLocationProperties;
import cn.unikue.springstarter.geolocation.util.GeoDatabaseUtils;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.WebServiceClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={GeoLocationProperties.class})
@ConditionalOnBooleanProperty(prefix="spring.geo-location", name={"enabled"}, matchIfMissing=true)
public class GeoLocationAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.geo-location";
    public static final String COUNTRY_DATABASE_READER = "geoCountryDatabaseReader";
    public static final String CITY_DATABASE_READER = "geoCityDatabaseReader";
    public static final String ASN_DATABASE_READER = "geoAsnDatabaseReader";
    public static final String WEB_SERVICE_CLIENT = "geoWebServiceClient";
    public static final String LOCATION_RESOLVER = "geoLocationResolver";

    @Bean(name={"geoCountryDatabaseReader"})
    @ConditionalOnMissingBean(name={"geoCountryDatabaseReader"})
    @ConditionalOnBooleanProperty(prefix="spring.geo-location.local-file", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.geo-location.local-file", name={"country-db"})
    public DatabaseReader countryDatabaseReader(@Nonnull GeoLocationProperties properties) throws IOException {
        return GeoDatabaseUtils.getDatabaseReader(properties, GeoDatabaseType.COUNTRY);
    }

    @Bean(name={"geoCityDatabaseReader"})
    @ConditionalOnMissingBean(name={"geoCityDatabaseReader"})
    @ConditionalOnBooleanProperty(prefix="spring.geo-location.local-file", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.geo-location.local-file", name={"city-db"})
    public DatabaseReader cityDatabaseReader(@Nonnull GeoLocationProperties properties) throws IOException {
        return GeoDatabaseUtils.getDatabaseReader(properties, GeoDatabaseType.CITY);
    }

    @Bean(name={"geoAsnDatabaseReader"})
    @ConditionalOnMissingBean(name={"geoAsnDatabaseReader"})
    @ConditionalOnBooleanProperty(prefix="spring.geo-location.local-file", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.geo-location.local-file", name={"asn-db"})
    public DatabaseReader asnDatabaseReader(@Nonnull GeoLocationProperties properties) throws IOException {
        return GeoDatabaseUtils.getDatabaseReader(properties, GeoDatabaseType.ASN);
    }

    @Bean(name={"geoWebServiceClient"})
    @ConditionalOnMissingBean(name={"geoWebServiceClient"})
    @ConditionalOnBooleanProperty(prefix="spring.geo-location.remote-site", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.geo-location.remote-site", name={"account-id", "license-key"})
    public WebServiceClient webServiceClient(@Nonnull GeoLocationProperties properties) {
        GeoLocationProperties.RemoteSite remoteSite = properties.getRemoteSite();
        WebServiceClient.Builder builder = new WebServiceClient.Builder(remoteSite.getAccountId().intValue(), remoteSite.getLicenseKey());
        if (StringUtils.isNotBlank((CharSequence)remoteSite.getHost())) {
            builder.host(remoteSite.getHost());
        }
        if (NumberUtilsWraps.isPositive((Number)remoteSite.getPort())) {
            builder.port(remoteSite.getPort().intValue());
        }
        if (BooleanUtils.isFalse((Boolean)remoteSite.getUseHttps())) {
            builder.disableHttps();
        }
        if (!CollectionUtils.isEmpty(remoteSite.getLocales())) {
            builder.locales(remoteSite.getLocales());
        }
        if (remoteSite.getConnectTimeout() != null) {
            builder.connectTimeout(remoteSite.getConnectTimeout());
        }
        if (remoteSite.getRequestTimeout() != null) {
            builder.requestTimeout(remoteSite.getRequestTimeout());
        }
        if (StringUtils.isNotBlank((CharSequence)remoteSite.getProxyHost()) && NumberUtilsWraps.isPositive((Number)remoteSite.getProxyPort())) {
            builder.proxy(InetProxyWraps.ofProxySelector((String)remoteSite.getProxyHost(), (int)remoteSite.getProxyPort()));
        }
        return builder.build();
    }

    @Bean(name={"geoLocationResolver"})
    @ConditionalOnMissingBean(name={"geoLocationResolver"})
    public GeoLocationResolver locationResolver(@Nonnull GeoLocationProperties properties, @Nullable @Qualifier(value="geoCountryDatabaseReader") DatabaseReader countryReader, @Nullable @Qualifier(value="geoCityDatabaseReader") DatabaseReader cityReader, @Nullable @Qualifier(value="geoWebServiceClient") WebServiceClient webClient) {
        return new DefaultGeoLocationResolver(countryReader, cityReader, webClient, BooleanUtils.isTrue((Boolean)properties.getDiscardLan()));
    }
}

