/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.geolocation.util;

import cn.unikue.commonplexus.javaseutil.util.NumberUtilsWraps;
import cn.unikue.commonplexus.springutil.util.ResourceUtilsWraps;
import cn.unikue.springstarter.geolocation.enumeration.GeoDatabaseType;
import cn.unikue.springstarter.geolocation.property.GeoLocationProperties;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public abstract class GeoDatabaseUtils {
    @Nonnull
    public static DatabaseReader getDatabaseReader(@Nonnull GeoLocationProperties properties, @Nonnull GeoDatabaseType type) throws IOException {
        GeoLocationProperties.LocalFile localFile = properties.getLocalFile();
        String location = null;
        switch (type) {
            case COUNTRY: {
                location = localFile.getCountryDb();
                break;
            }
            case CITY: {
                location = localFile.getCityDb();
                break;
            }
            case ASN: {
                location = localFile.getAsnDb();
                break;
            }
        }
        Resource resource = ResourceUtilsWraps.determineResource(location);
        if (resource == null || !resource.exists() || !resource.isReadable()) {
            throw new FileNotFoundException("Location database is not exists or readable");
        }
        DatabaseReader.Builder builder = new DatabaseReader.Builder(resource.getInputStream());
        if (!CollectionUtils.isEmpty(localFile.getLocales())) {
            builder.locales(localFile.getLocales());
        }
        switch (localFile.getCacheType()) {
            case NO: {
                builder.withCache((NodeCache)NoCache.getInstance());
                break;
            }
            case CHM: {
                builder.withCache((NodeCache)(NumberUtilsWraps.isPositive((Number)localFile.getCacheCapacity()) ? new CHMCache(localFile.getCacheCapacity().intValue()) : new CHMCache()));
                break;
            }
        }
        return builder.build();
    }
}

