/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.config;

import cn.unikue.springstarter.httpclient.property.HttpClientProperties;
import cn.unikue.springstarter.httpclient.util.AsyncHttpClientBuilderUtils;
import cn.unikue.springstarter.httpclient.util.SyncHttpClientBuilderUtils;
import jakarta.annotation.Nonnull;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.HttpVersion;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.http-client", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={HttpVersion.class})
@EnableConfigurationProperties(value={HttpClientProperties.class})
@AutoConfigureOrder(value=2147482647)
public class HttpClientAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.http-client";
    public static final String SYNC_HTTP_CLIENT = "syncHttpClient";
    public static final String ASYNC_HTTP_CLIENT = "asyncHttpClient";

    @Bean(name={"syncHttpClient"})
    @ConditionalOnBooleanProperty(prefix="spring.http-client.sync-client", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnMissingBean(name={"syncHttpClient"})
    public HttpClient syncHttpClient(@Nonnull HttpClientProperties properties) {
        return SyncHttpClientBuilderUtils.clientBuilder(properties.getSyncClient()).build();
    }

    @Bean(name={"asyncHttpClient"})
    @ConditionalOnBooleanProperty(prefix="spring.http-client.async-client", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HttpAsyncClient.class})
    @ConditionalOnMissingBean(name={"asyncHttpClient"})
    public HttpAsyncClient asyncHttpClient(@Nonnull HttpClientProperties properties) {
        return AsyncHttpClientBuilderUtils.clientBuilder(properties.getAsyncClient()).build();
    }
}

