/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.property;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.util.VersionInfo;
import org.springframework.boot.convert.DurationUnit;

public abstract class AbstractHttpClientProperties
implements Serializable {
    private Boolean enabled = true;
    private String userAgent = "Apache-HttpClient";
    private String proxyHost;
    private Integer proxyPort;
    private Boolean authCachingEnabled;
    private Boolean automaticRetriesEnabled;
    private Boolean connectionManagerShared;
    private Boolean connectionStateEnabled;
    private Boolean cookieManagementEnabled;
    private Boolean evictExpiredConnections;
    private Boolean evictIdleConnections;
    private Boolean redirectHandlingEnabled;
    private Boolean useSystemProperties;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxIdleTime;
    private Class<? extends HttpRoutePlanner> routePlanner;
    private Class<? extends CookieStore> cookieStore;
    private Class<? extends ConnectionKeepAliveStrategy> keepAliveStrategy;
    private Class<? extends ConnectionReuseStrategy> reuseStrategy;
    private Class<? extends AuthenticationStrategy> proxyAuthStrategy;
    private Class<? extends AuthenticationStrategy> targetAuthStrategy;
    private Class<? extends RedirectStrategy> redirectStrategy;
    private Class<? extends HttpRequestRetryStrategy> retryStrategy;
    private Class<? extends CredentialsProvider> credentialsProvider;
    private Class<? extends SchemePortResolver> schemePortResolver;
    private Class<? extends UserTokenHandler> userTokenHandler;
    private List<Class<? extends HttpRequestInterceptor>> requestInterceptors;
    private List<Class<? extends HttpResponseInterceptor>> responseInterceptors;
    private Map<String, Class<? extends AuthSchemeFactory>> authSchemeFactories;
    private Map<String, Class<? extends CookieSpecFactory>> cookieSpecFactories;
    private Map<String, String> defaultHeaders;
    private final DefaultRequestConfig defaultRequestConfig = new DefaultRequestConfig();

    public AbstractHttpClientProperties() {
        VersionInfo versionInfo = VersionInfo.loadVersionInfo((String)"org.apache.hc.core5", null);
        if (versionInfo != null) {
            this.userAgent = this.userAgent + String.format("/%s (Java/%s)", versionInfo.getRelease(), SystemUtils.JAVA_VERSION);
        }
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public Boolean getAuthCachingEnabled() {
        return this.authCachingEnabled;
    }

    @Generated
    public Boolean getAutomaticRetriesEnabled() {
        return this.automaticRetriesEnabled;
    }

    @Generated
    public Boolean getConnectionManagerShared() {
        return this.connectionManagerShared;
    }

    @Generated
    public Boolean getConnectionStateEnabled() {
        return this.connectionStateEnabled;
    }

    @Generated
    public Boolean getCookieManagementEnabled() {
        return this.cookieManagementEnabled;
    }

    @Generated
    public Boolean getEvictExpiredConnections() {
        return this.evictExpiredConnections;
    }

    @Generated
    public Boolean getEvictIdleConnections() {
        return this.evictIdleConnections;
    }

    @Generated
    public Boolean getRedirectHandlingEnabled() {
        return this.redirectHandlingEnabled;
    }

    @Generated
    public Boolean getUseSystemProperties() {
        return this.useSystemProperties;
    }

    @Generated
    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Generated
    public Class<? extends HttpRoutePlanner> getRoutePlanner() {
        return this.routePlanner;
    }

    @Generated
    public Class<? extends CookieStore> getCookieStore() {
        return this.cookieStore;
    }

    @Generated
    public Class<? extends ConnectionKeepAliveStrategy> getKeepAliveStrategy() {
        return this.keepAliveStrategy;
    }

    @Generated
    public Class<? extends ConnectionReuseStrategy> getReuseStrategy() {
        return this.reuseStrategy;
    }

    @Generated
    public Class<? extends AuthenticationStrategy> getProxyAuthStrategy() {
        return this.proxyAuthStrategy;
    }

    @Generated
    public Class<? extends AuthenticationStrategy> getTargetAuthStrategy() {
        return this.targetAuthStrategy;
    }

    @Generated
    public Class<? extends RedirectStrategy> getRedirectStrategy() {
        return this.redirectStrategy;
    }

    @Generated
    public Class<? extends HttpRequestRetryStrategy> getRetryStrategy() {
        return this.retryStrategy;
    }

    @Generated
    public Class<? extends CredentialsProvider> getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Generated
    public Class<? extends SchemePortResolver> getSchemePortResolver() {
        return this.schemePortResolver;
    }

    @Generated
    public Class<? extends UserTokenHandler> getUserTokenHandler() {
        return this.userTokenHandler;
    }

    @Generated
    public List<Class<? extends HttpRequestInterceptor>> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Generated
    public List<Class<? extends HttpResponseInterceptor>> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    @Generated
    public Map<String, Class<? extends AuthSchemeFactory>> getAuthSchemeFactories() {
        return this.authSchemeFactories;
    }

    @Generated
    public Map<String, Class<? extends CookieSpecFactory>> getCookieSpecFactories() {
        return this.cookieSpecFactories;
    }

    @Generated
    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Generated
    public DefaultRequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setAuthCachingEnabled(Boolean authCachingEnabled) {
        this.authCachingEnabled = authCachingEnabled;
    }

    @Generated
    public void setAutomaticRetriesEnabled(Boolean automaticRetriesEnabled) {
        this.automaticRetriesEnabled = automaticRetriesEnabled;
    }

    @Generated
    public void setConnectionManagerShared(Boolean connectionManagerShared) {
        this.connectionManagerShared = connectionManagerShared;
    }

    @Generated
    public void setConnectionStateEnabled(Boolean connectionStateEnabled) {
        this.connectionStateEnabled = connectionStateEnabled;
    }

    @Generated
    public void setCookieManagementEnabled(Boolean cookieManagementEnabled) {
        this.cookieManagementEnabled = cookieManagementEnabled;
    }

    @Generated
    public void setEvictExpiredConnections(Boolean evictExpiredConnections) {
        this.evictExpiredConnections = evictExpiredConnections;
    }

    @Generated
    public void setEvictIdleConnections(Boolean evictIdleConnections) {
        this.evictIdleConnections = evictIdleConnections;
    }

    @Generated
    public void setRedirectHandlingEnabled(Boolean redirectHandlingEnabled) {
        this.redirectHandlingEnabled = redirectHandlingEnabled;
    }

    @Generated
    public void setUseSystemProperties(Boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    @Generated
    public void setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Generated
    public void setRoutePlanner(Class<? extends HttpRoutePlanner> routePlanner) {
        this.routePlanner = routePlanner;
    }

    @Generated
    public void setCookieStore(Class<? extends CookieStore> cookieStore) {
        this.cookieStore = cookieStore;
    }

    @Generated
    public void setKeepAliveStrategy(Class<? extends ConnectionKeepAliveStrategy> keepAliveStrategy) {
        this.keepAliveStrategy = keepAliveStrategy;
    }

    @Generated
    public void setReuseStrategy(Class<? extends ConnectionReuseStrategy> reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    @Generated
    public void setProxyAuthStrategy(Class<? extends AuthenticationStrategy> proxyAuthStrategy) {
        this.proxyAuthStrategy = proxyAuthStrategy;
    }

    @Generated
    public void setTargetAuthStrategy(Class<? extends AuthenticationStrategy> targetAuthStrategy) {
        this.targetAuthStrategy = targetAuthStrategy;
    }

    @Generated
    public void setRedirectStrategy(Class<? extends RedirectStrategy> redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    @Generated
    public void setRetryStrategy(Class<? extends HttpRequestRetryStrategy> retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    @Generated
    public void setCredentialsProvider(Class<? extends CredentialsProvider> credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Generated
    public void setSchemePortResolver(Class<? extends SchemePortResolver> schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
    }

    @Generated
    public void setUserTokenHandler(Class<? extends UserTokenHandler> userTokenHandler) {
        this.userTokenHandler = userTokenHandler;
    }

    @Generated
    public void setRequestInterceptors(List<Class<? extends HttpRequestInterceptor>> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    @Generated
    public void setResponseInterceptors(List<Class<? extends HttpResponseInterceptor>> responseInterceptors) {
        this.responseInterceptors = responseInterceptors;
    }

    @Generated
    public void setAuthSchemeFactories(Map<String, Class<? extends AuthSchemeFactory>> authSchemeFactories) {
        this.authSchemeFactories = authSchemeFactories;
    }

    @Generated
    public void setCookieSpecFactories(Map<String, Class<? extends CookieSpecFactory>> cookieSpecFactories) {
        this.cookieSpecFactories = cookieSpecFactories;
    }

    @Generated
    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    @Generated
    public String toString() {
        return "AbstractHttpClientProperties(enabled=" + this.getEnabled() + ", userAgent=" + this.getUserAgent() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", authCachingEnabled=" + this.getAuthCachingEnabled() + ", automaticRetriesEnabled=" + this.getAutomaticRetriesEnabled() + ", connectionManagerShared=" + this.getConnectionManagerShared() + ", connectionStateEnabled=" + this.getConnectionStateEnabled() + ", cookieManagementEnabled=" + this.getCookieManagementEnabled() + ", evictExpiredConnections=" + this.getEvictExpiredConnections() + ", evictIdleConnections=" + this.getEvictIdleConnections() + ", redirectHandlingEnabled=" + this.getRedirectHandlingEnabled() + ", useSystemProperties=" + this.getUseSystemProperties() + ", maxIdleTime=" + String.valueOf(this.getMaxIdleTime()) + ", routePlanner=" + String.valueOf(this.getRoutePlanner()) + ", cookieStore=" + String.valueOf(this.getCookieStore()) + ", keepAliveStrategy=" + String.valueOf(this.getKeepAliveStrategy()) + ", reuseStrategy=" + String.valueOf(this.getReuseStrategy()) + ", proxyAuthStrategy=" + String.valueOf(this.getProxyAuthStrategy()) + ", targetAuthStrategy=" + String.valueOf(this.getTargetAuthStrategy()) + ", redirectStrategy=" + String.valueOf(this.getRedirectStrategy()) + ", retryStrategy=" + String.valueOf(this.getRetryStrategy()) + ", credentialsProvider=" + String.valueOf(this.getCredentialsProvider()) + ", schemePortResolver=" + String.valueOf(this.getSchemePortResolver()) + ", userTokenHandler=" + String.valueOf(this.getUserTokenHandler()) + ", requestInterceptors=" + String.valueOf(this.getRequestInterceptors()) + ", responseInterceptors=" + String.valueOf(this.getResponseInterceptors()) + ", authSchemeFactories=" + String.valueOf(this.getAuthSchemeFactories()) + ", cookieSpecFactories=" + String.valueOf(this.getCookieSpecFactories()) + ", defaultHeaders=" + String.valueOf(this.getDefaultHeaders()) + ", defaultRequestConfig=" + String.valueOf(this.getDefaultRequestConfig()) + ")";
    }

    public static class DefaultRequestConfig
    implements Serializable {
        private Boolean enabled;
        private Boolean expectContinueEnabled;
        private String cookieSpec;
        private Boolean redirectsEnabled = Boolean.TRUE;
        private Boolean circularRedirectsAllowed;
        private Integer maxRedirects;
        private Boolean authenticationEnabled = Boolean.TRUE;
        private List<String> targetPreferredAuthSchemes;
        private List<String> proxyPreferredAuthSchemes;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration requestTimeout = Duration.ofSeconds(30L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration responseTimeout = Duration.ofMinutes(3L);
        private Duration connectionKeepAlive;
        private Boolean contentCompressionEnabled = Boolean.TRUE;
        private Boolean hardCancellationEnabled = Boolean.TRUE;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Boolean getExpectContinueEnabled() {
            return this.expectContinueEnabled;
        }

        @Generated
        public String getCookieSpec() {
            return this.cookieSpec;
        }

        @Generated
        public Boolean getRedirectsEnabled() {
            return this.redirectsEnabled;
        }

        @Generated
        public Boolean getCircularRedirectsAllowed() {
            return this.circularRedirectsAllowed;
        }

        @Generated
        public Integer getMaxRedirects() {
            return this.maxRedirects;
        }

        @Generated
        public Boolean getAuthenticationEnabled() {
            return this.authenticationEnabled;
        }

        @Generated
        public List<String> getTargetPreferredAuthSchemes() {
            return this.targetPreferredAuthSchemes;
        }

        @Generated
        public List<String> getProxyPreferredAuthSchemes() {
            return this.proxyPreferredAuthSchemes;
        }

        @Generated
        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        @Generated
        public Duration getResponseTimeout() {
            return this.responseTimeout;
        }

        @Generated
        public Duration getConnectionKeepAlive() {
            return this.connectionKeepAlive;
        }

        @Generated
        public Boolean getContentCompressionEnabled() {
            return this.contentCompressionEnabled;
        }

        @Generated
        public Boolean getHardCancellationEnabled() {
            return this.hardCancellationEnabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setExpectContinueEnabled(Boolean expectContinueEnabled) {
            this.expectContinueEnabled = expectContinueEnabled;
        }

        @Generated
        public void setCookieSpec(String cookieSpec) {
            this.cookieSpec = cookieSpec;
        }

        @Generated
        public void setRedirectsEnabled(Boolean redirectsEnabled) {
            this.redirectsEnabled = redirectsEnabled;
        }

        @Generated
        public void setCircularRedirectsAllowed(Boolean circularRedirectsAllowed) {
            this.circularRedirectsAllowed = circularRedirectsAllowed;
        }

        @Generated
        public void setMaxRedirects(Integer maxRedirects) {
            this.maxRedirects = maxRedirects;
        }

        @Generated
        public void setAuthenticationEnabled(Boolean authenticationEnabled) {
            this.authenticationEnabled = authenticationEnabled;
        }

        @Generated
        public void setTargetPreferredAuthSchemes(List<String> targetPreferredAuthSchemes) {
            this.targetPreferredAuthSchemes = targetPreferredAuthSchemes;
        }

        @Generated
        public void setProxyPreferredAuthSchemes(List<String> proxyPreferredAuthSchemes) {
            this.proxyPreferredAuthSchemes = proxyPreferredAuthSchemes;
        }

        @Generated
        public void setRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        @Generated
        public void setResponseTimeout(Duration responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        @Generated
        public void setConnectionKeepAlive(Duration connectionKeepAlive) {
            this.connectionKeepAlive = connectionKeepAlive;
        }

        @Generated
        public void setContentCompressionEnabled(Boolean contentCompressionEnabled) {
            this.contentCompressionEnabled = contentCompressionEnabled;
        }

        @Generated
        public void setHardCancellationEnabled(Boolean hardCancellationEnabled) {
            this.hardCancellationEnabled = hardCancellationEnabled;
        }

        @Generated
        public String toString() {
            return "AbstractHttpClientProperties.DefaultRequestConfig(enabled=" + this.getEnabled() + ", expectContinueEnabled=" + this.getExpectContinueEnabled() + ", cookieSpec=" + this.getCookieSpec() + ", redirectsEnabled=" + this.getRedirectsEnabled() + ", circularRedirectsAllowed=" + this.getCircularRedirectsAllowed() + ", maxRedirects=" + this.getMaxRedirects() + ", authenticationEnabled=" + this.getAuthenticationEnabled() + ", targetPreferredAuthSchemes=" + String.valueOf(this.getTargetPreferredAuthSchemes()) + ", proxyPreferredAuthSchemes=" + String.valueOf(this.getProxyPreferredAuthSchemes()) + ", requestTimeout=" + String.valueOf(this.getRequestTimeout()) + ", responseTimeout=" + String.valueOf(this.getResponseTimeout()) + ", connectionKeepAlive=" + String.valueOf(this.getConnectionKeepAlive()) + ", contentCompressionEnabled=" + this.getContentCompressionEnabled() + ", hardCancellationEnabled=" + this.getHardCancellationEnabled() + ")";
        }
    }
}

