/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.util;

import cn.unikue.springstarter.httpclient.property.AbstractHttpClientProperties;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public abstract class AbstractHttpClientBuilderUtils {
    @Nullable
    public static RequestConfig buildRequestConfig(@Nullable AbstractHttpClientProperties.DefaultRequestConfig properties) {
        if (properties == null || BooleanUtils.isFalse((Boolean)properties.getEnabled())) {
            return null;
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setExpectContinueEnabled(BooleanUtils.isTrue((Boolean)properties.getExpectContinueEnabled()));
        if (StringUtils.isNotBlank((CharSequence)properties.getCookieSpec())) {
            builder.setCookieSpec(properties.getCookieSpec());
        }
        builder.setRedirectsEnabled(BooleanUtils.isTrue((Boolean)properties.getRedirectsEnabled()));
        builder.setCircularRedirectsAllowed(BooleanUtils.isTrue((Boolean)properties.getCircularRedirectsAllowed()));
        if (properties.getMaxRedirects() != null) {
            builder.setMaxRedirects(properties.getMaxRedirects().intValue());
        }
        builder.setAuthenticationEnabled(BooleanUtils.isTrue((Boolean)properties.getAuthenticationEnabled()));
        builder.setTargetPreferredAuthSchemes(properties.getTargetPreferredAuthSchemes());
        builder.setProxyPreferredAuthSchemes(properties.getProxyPreferredAuthSchemes());
        if (properties.getRequestTimeout() != null) {
            builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)properties.getRequestTimeout().toMillis()));
        }
        if (properties.getResponseTimeout() != null) {
            builder.setResponseTimeout(Timeout.ofMilliseconds((long)properties.getResponseTimeout().toMillis()));
        }
        if (properties.getConnectionKeepAlive() != null) {
            builder.setConnectionKeepAlive(TimeValue.ofMilliseconds((long)properties.getConnectionKeepAlive().toMillis()));
        }
        builder.setContentCompressionEnabled(BooleanUtils.isTrue((Boolean)properties.getContentCompressionEnabled()));
        builder.setHardCancellationEnabled(BooleanUtils.isTrue((Boolean)properties.getHardCancellationEnabled()));
        return builder.build();
    }
}

