/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.springframework.util.CollectionUtils;

public abstract class CookieStoreUtils {
    @Nullable
    public Cookie getCookie(@Nonnull CookieStore store, @Nonnull String name) {
        if (CollectionUtils.isEmpty((Collection)store.getCookies()) || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return store.getCookies().stream().filter(cookie -> StringUtils.equals((CharSequence)name, (CharSequence)cookie.getName())).findFirst().orElse(null);
    }

    @Nullable
    public String getCookieValue(@Nonnull CookieStore store, @Nonnull String name) {
        Cookie cookie = this.getCookie(store, name);
        return cookie == null ? null : cookie.getValue();
    }

    @Nullable
    public String getCookiesAsString(@Nonnull CookieStore store) {
        return this.getCookiesAsString(store, "=", ";");
    }

    @Nullable
    public String getCookiesAsString(@Nonnull CookieStore store, char keyValueDelimiter, char groupDelimiter) {
        return this.getCookiesAsString(store, CharUtils.toString((char)keyValueDelimiter), CharUtils.toString((char)groupDelimiter));
    }

    @Nullable
    public String getCookiesAsString(@Nonnull CookieStore store, @Nullable String keyValueDelimiter, @Nullable String groupDelimiter) {
        if (CollectionUtils.isEmpty((Collection)store.getCookies())) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(Objects.toString(groupDelimiter, ""));
        store.getCookies().forEach(cookie -> joiner.add(StringUtils.join((Object[])new String[]{cookie.getName(), Objects.toString(keyValueDelimiter, ""), StringUtils.defaultString((String)cookie.getValue())})));
        return joiner.toString();
    }
}

