/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.util;

import jakarta.annotation.Nullable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.util.Timeout;

public abstract class RequestConfigUtils {
    public static final Timeout REQUEST_TIMEOUT = Timeout.ofSeconds((long)30L);
    public static final Timeout CONNECT_TIMEOUT = Timeout.ofSeconds((long)30L);
    public static final Timeout RESPONSE_TIMEOUT = Timeout.ofMinutes((long)3L);

    public static RequestConfig withDefaultTimeouts() {
        return RequestConfigUtils.withSpecifiedTimeouts(REQUEST_TIMEOUT, CONNECT_TIMEOUT, RESPONSE_TIMEOUT);
    }

    public static RequestConfig withSpecifiedTimeouts(@Nullable Timeout requestTimeout, @Nullable Timeout connectTimeout, @Nullable Timeout responseTimeout) {
        return RequestConfig.custom().setConnectionRequestTimeout(requestTimeout).setResponseTimeout(responseTimeout).build();
    }

    @Nullable
    public static RequestConfig restrictWithDefaultTimeouts(@Nullable RequestConfig config) {
        if (config == null) {
            return null;
        }
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)config);
        if (config.getConnectionRequestTimeout() == null || config.getConnectionRequestTimeout().isDisabled()) {
            builder.setConnectionRequestTimeout(REQUEST_TIMEOUT);
        }
        if (config.getResponseTimeout() == null || config.getResponseTimeout().isDisabled()) {
            builder.setResponseTimeout(RESPONSE_TIMEOUT);
        }
        return builder.build();
    }
}

