/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.util;

import cn.unikue.springstarter.httpclient.property.SyncHttpClientProperties;
import cn.unikue.springstarter.httpclient.util.AbstractHttpClientBuilderUtils;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.BackoffManager;
import org.apache.hc.client5.http.classic.ConnectionBackoffStrategy;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.InputStreamFactory;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.LookupRegistryUtils;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.util.TimeValue;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public abstract class SyncHttpClientBuilderUtils {
    @Nonnull
    public static HttpClientBuilder clientBuilder(@Nonnull SyncHttpClientProperties properties) throws BeanInstantiationException {
        RequestConfig requestConfig;
        LinkedHashMap<String, Object> nameFactories;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNotBlank((CharSequence)properties.getProxyHost()) && properties.getProxyPort() != null && properties.getProxyPort() > 0) {
            builder.setProxy(new HttpHost(properties.getProxyHost(), properties.getProxyPort().intValue()));
        }
        if (BooleanUtils.isFalse((Boolean)properties.getAuthCachingEnabled())) {
            builder.disableAuthCaching();
        }
        if (BooleanUtils.isFalse((Boolean)properties.getAutomaticRetriesEnabled())) {
            builder.disableAutomaticRetries();
        }
        builder.setConnectionManagerShared(BooleanUtils.isTrue((Boolean)properties.getConnectionManagerShared()));
        if (BooleanUtils.isFalse((Boolean)properties.getConnectionStateEnabled())) {
            builder.disableConnectionState();
        }
        if (BooleanUtils.isFalse((Boolean)properties.getCookieManagementEnabled())) {
            builder.disableCookieManagement();
        }
        if (BooleanUtils.isTrue((Boolean)properties.getEvictExpiredConnections())) {
            builder.evictExpiredConnections();
        }
        if (BooleanUtils.isTrue((Boolean)properties.getEvictIdleConnections()) && properties.getMaxIdleTime() != null) {
            builder.evictIdleConnections(TimeValue.ofMilliseconds((long)properties.getMaxIdleTime().toMillis()));
        }
        if (BooleanUtils.isFalse((Boolean)properties.getRedirectHandlingEnabled())) {
            builder.disableRedirectHandling();
        }
        if (BooleanUtils.isTrue((Boolean)properties.getUseSystemProperties())) {
            builder.useSystemProperties();
        }
        if (properties.getRoutePlanner() != null) {
            builder.setRoutePlanner((HttpRoutePlanner)BeanUtils.instantiateClass(properties.getRoutePlanner()));
        }
        if (properties.getCookieStore() != null) {
            builder.setDefaultCookieStore((CookieStore)BeanUtils.instantiateClass(properties.getCookieStore()));
        }
        if (properties.getKeepAliveStrategy() != null) {
            builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)BeanUtils.instantiateClass(properties.getKeepAliveStrategy()));
        }
        if (properties.getReuseStrategy() != null) {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)BeanUtils.instantiateClass(properties.getReuseStrategy()));
        }
        if (properties.getProxyAuthStrategy() != null) {
            builder.setProxyAuthenticationStrategy((AuthenticationStrategy)BeanUtils.instantiateClass(properties.getProxyAuthStrategy()));
        }
        if (properties.getTargetAuthStrategy() != null) {
            builder.setTargetAuthenticationStrategy((AuthenticationStrategy)BeanUtils.instantiateClass(properties.getTargetAuthStrategy()));
        }
        if (properties.getRedirectStrategy() != null) {
            builder.setRedirectStrategy((RedirectStrategy)BeanUtils.instantiateClass(properties.getRedirectStrategy()));
        }
        if (properties.getCredentialsProvider() != null) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)BeanUtils.instantiateClass(properties.getCredentialsProvider()));
        }
        if (properties.getSchemePortResolver() != null) {
            builder.setSchemePortResolver((SchemePortResolver)BeanUtils.instantiateClass(properties.getSchemePortResolver()));
        }
        if (properties.getUserTokenHandler() != null) {
            builder.setUserTokenHandler((UserTokenHandler)BeanUtils.instantiateClass(properties.getUserTokenHandler()));
        }
        if (!CollectionUtils.isEmpty(properties.getRequestInterceptors())) {
            for (Class<? extends HttpRequestInterceptor> clazz : properties.getRequestInterceptors()) {
                builder.addRequestInterceptorLast((HttpRequestInterceptor)BeanUtils.instantiateClass(clazz));
            }
        }
        if (!CollectionUtils.isEmpty(properties.getResponseInterceptors())) {
            for (Class<? extends HttpRequestInterceptor> clazz : properties.getResponseInterceptors()) {
                builder.addResponseInterceptorLast((HttpResponseInterceptor)BeanUtils.instantiateClass(clazz));
            }
        }
        if (!CollectionUtils.isEmpty(properties.getAuthSchemeFactories())) {
            nameFactories = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Class<? extends AuthSchemeFactory>> entry : properties.getAuthSchemeFactories().entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                nameFactories.put(entry.getKey(), (AuthSchemeFactory)BeanUtils.instantiateClass(entry.getValue()));
            }
            if (!CollectionUtils.isEmpty(nameFactories)) {
                builder.setDefaultAuthSchemeRegistry(LookupRegistryUtils.registryWithin(nameFactories));
            }
        }
        if (!CollectionUtils.isEmpty(properties.getCookieSpecFactories())) {
            nameFactories = new LinkedHashMap();
            for (Map.Entry<String, Class<? extends CookieSpecFactory>> entry : properties.getCookieSpecFactories().entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                nameFactories.put(entry.getKey(), (CookieSpecFactory)BeanUtils.instantiateClass(entry.getValue()));
            }
            if (!CollectionUtils.isEmpty(nameFactories)) {
                builder.setDefaultCookieSpecRegistry(LookupRegistryUtils.registryWithin(nameFactories));
            }
        }
        if (!CollectionUtils.isEmpty(properties.getDefaultHeaders())) {
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(properties.getDefaultHeaders().size());
            for (Map.Entry<String, String> entry : properties.getDefaultHeaders().entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey())) continue;
                headers.add(new BasicHeader(entry.getKey(), (Object)entry.getValue()));
            }
            builder.setDefaultHeaders(headers);
        }
        if ((requestConfig = AbstractHttpClientBuilderUtils.buildRequestConfig(properties.getDefaultRequestConfig())) != null) {
            builder.setDefaultRequestConfig(requestConfig);
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getUserAgent())) {
            builder.setUserAgent(properties.getUserAgent());
        }
        if (BooleanUtils.isFalse((Boolean)properties.getDefaultUserAgentEnabled())) {
            builder.disableDefaultUserAgent();
        }
        if (properties.getConnectionManager() != null) {
            builder.setConnectionManager((HttpClientConnectionManager)BeanUtils.instantiateClass(properties.getConnectionManager()));
        }
        if (properties.getRequestExecutor() != null) {
            builder.setRequestExecutor((HttpRequestExecutor)BeanUtils.instantiateClass(properties.getRequestExecutor()));
        }
        if (properties.getBackoffManager() != null) {
            builder.setBackoffManager((BackoffManager)BeanUtils.instantiateClass(properties.getBackoffManager()));
        }
        if (properties.getConnectionBackoffStrategy() != null) {
            builder.setConnectionBackoffStrategy((ConnectionBackoffStrategy)BeanUtils.instantiateClass(properties.getConnectionBackoffStrategy()));
        }
        if (!CollectionUtils.isEmpty(properties.getExecInterceptors())) {
            for (Map.Entry<String, Class<? extends ExecChainHandler>> entry : properties.getExecInterceptors().entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                builder.addExecInterceptorLast(entry.getKey(), (ExecChainHandler)BeanUtils.instantiateClass(entry.getValue()));
            }
        }
        if (!CollectionUtils.isEmpty(properties.getContentDecoderFactories())) {
            LinkedHashMap<String, InputStreamFactory> linkedHashMap = new LinkedHashMap<String, InputStreamFactory>();
            for (Map.Entry<String, Class<? extends InputStreamFactory>> entry : properties.getContentDecoderFactories().entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                linkedHashMap.put(entry.getKey(), (InputStreamFactory)BeanUtils.instantiateClass(entry.getValue()));
            }
            if (!CollectionUtils.isEmpty(linkedHashMap)) {
                builder.setContentDecoderRegistry(linkedHashMap);
            }
        }
        return builder;
    }
}

