/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.httpclient.util;

import cn.unikue.springstarter.httpclient.util.RequestConfigUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class SyncHttpClientExecutorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncHttpClientExecutorUtils.class);

    public static <T> T executeHandler(@Nonnull HttpClient client, @Nonnull ClassicHttpRequest request, @Nullable HttpContext context, @Nonnull HttpClientResponseHandler<? extends T> handler) throws IOException, URISyntaxException {
        if (log.isDebugEnabled()) {
            log.debug("Preparing to visit: {}", (Object)request.getUri());
        }
        if (!request.containsHeader("Accept")) {
            request.addHeader("Accept", (Object)ContentType.WILDCARD.getMimeType());
        }
        return (T)client.execute(request, context, handler);
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String pathname) throws IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.downloadSimply(client, uri, pathname, RequestConfigUtils.withDefaultTimeouts());
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String pathname, @Nullable RequestConfig config) throws IOException, URISyntaxException {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uri, pathname}) && SyncHttpClientExecutorUtils.downloadSimply(client, uri, Files.newOutputStream(Paths.get(pathname, new String[0]), new OpenOption[0]), config);
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull File output) throws IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.downloadSimply(client, uri, output, RequestConfigUtils.withDefaultTimeouts());
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull File output, @Nullable RequestConfig config) throws IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.downloadSimply(client, uri, output, config, null, null);
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull File output, @Nullable RequestConfig config, @Nullable List<NameValuePair> parameters, @Nullable Charset charset) throws IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.downloadSimply(client, uri, Files.newOutputStream(output.toPath(), new OpenOption[0]), config, null, null);
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull OutputStream output) throws IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.downloadSimply(client, uri, output, RequestConfigUtils.withDefaultTimeouts());
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull OutputStream output, @Nullable RequestConfig config) throws IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.downloadSimply(client, uri, output, config, null, null);
    }

    public static boolean downloadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull OutputStream output, @Nullable RequestConfig config, @Nullable List<NameValuePair> parameters, @Nullable Charset charset) throws IOException, URISyntaxException {
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            ClassicHttpRequest request;
            config = (RequestConfig)ObjectUtils.defaultIfNull((Object)config, (Object)RequestConfigUtils.withDefaultTimeouts());
            charset = (Charset)ObjectUtils.defaultIfNull((Object)charset, (Object)StandardCharsets.UTF_8);
            ClassicRequestBuilder builder = ClassicRequestBuilder.get((String)uri).setCharset(charset);
            if (!CollectionUtils.isEmpty(parameters)) {
                parameters.stream().filter(Objects::nonNull).forEach(arg_0 -> ((ClassicRequestBuilder)builder).addParameter(arg_0));
            }
            if ((request = builder.build()) instanceof HttpUriRequestBase) {
                ((HttpUriRequestBase)request).setConfig(config);
            }
            HttpClientResponseHandler handler = response -> {
                if (response.getCode() == 200 && response.getEntity() != null) {
                    response.getEntity().writeTo(output);
                    output.close();
                    return true;
                }
                return false;
            };
            return BooleanUtils.isTrue((Boolean)((Boolean)SyncHttpClientExecutorUtils.executeHandler(client, request, null, handler)));
        }
        return false;
    }

    public static boolean uploadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String formField, @Nonnull File input) throws IllegalAccessException, IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.uploadSimply(client, uri, formField, input, RequestConfigUtils.withDefaultTimeouts());
    }

    public static boolean uploadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String formField, @Nonnull File input, @Nullable RequestConfig config) throws IllegalAccessException, IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.uploadSimply(client, uri, formField, input, config, null, null);
    }

    public static boolean uploadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String formField, @Nonnull String pathname) throws IllegalAccessException, IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.uploadSimply(client, uri, formField, pathname, RequestConfigUtils.withDefaultTimeouts());
    }

    public static boolean uploadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String formField, @Nonnull String pathname, @Nullable RequestConfig config) throws IllegalAccessException, IOException, URISyntaxException {
        return SyncHttpClientExecutorUtils.uploadSimply(client, uri, formField, pathname, config, null, null);
    }

    public static boolean uploadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String formField, @Nonnull String pathname, @Nullable RequestConfig config, @Nullable List<NameValuePair> parameters, @Nullable Charset charset) throws IllegalAccessException, IOException, URISyntaxException {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uri, formField, pathname}) && SyncHttpClientExecutorUtils.uploadSimply(client, uri, formField, new File(pathname), config, parameters, charset);
    }

    public static boolean uploadSimply(@Nonnull HttpClient client, @Nonnull String uri, @Nonnull String formField, @Nonnull File input, @Nullable RequestConfig config, @Nullable List<NameValuePair> parameters, @Nullable Charset charset) throws IllegalAccessException, IOException, URISyntaxException {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uri, formField})) {
            ClassicHttpRequest request;
            if (!input.exists() || !input.isFile()) {
                throw new FileNotFoundException();
            }
            if (!input.canRead()) {
                throw new IllegalAccessException();
            }
            config = (RequestConfig)ObjectUtils.defaultIfNull((Object)config, (Object)RequestConfigUtils.withDefaultTimeouts());
            charset = (Charset)ObjectUtils.defaultIfNull((Object)charset, (Object)StandardCharsets.UTF_8);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(charset);
            builder.addBinaryBody(formField, input, ContentType.MULTIPART_FORM_DATA, input.getName());
            if (!CollectionUtils.isEmpty(parameters)) {
                parameters.stream().filter(Objects::nonNull).forEach(pair -> builder.addTextBody(pair.getName(), pair.getValue()));
            }
            if ((request = ClassicRequestBuilder.post((String)uri).setCharset(charset).build()) instanceof HttpUriRequestBase) {
                ((HttpUriRequestBase)request).setConfig(config);
            }
            HttpClientResponseHandler handler = response -> response.getCode() == 200;
            return BooleanUtils.isTrue((Boolean)((Boolean)SyncHttpClientExecutorUtils.executeHandler(client, request, null, handler)));
        }
        return false;
    }
}

