/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.minio.config;

import cn.unikue.commonplexus.springutil.property.MinioProperties;
import cn.unikue.commonplexus.springutil.util.MinioConfigWraps;
import io.minio.MinioClient;
import jakarta.annotation.Nonnull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.minio", name={"endpoint"})
@ConditionalOnClass(value={MinioClient.class})
public class MinioAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.minio";
    public static final String MINIO_PROPERTIES = "minioProperties";
    public static final String MINIO_CLIENT = "minioClient";

    @Bean(name={"minioProperties"})
    @ConfigurationProperties(prefix="spring.minio")
    @ConditionalOnMissingBean(name={"minioProperties"})
    public MinioProperties minioProperties() {
        return new MinioProperties();
    }

    @Bean(name={"minioClient"})
    @ConditionalOnMissingBean(name={"minioClient"})
    public MinioClient minioClient(@Nonnull MinioProperties properties) throws Exception {
        return MinioConfigWraps.minioClient((MinioProperties)properties);
    }
}

