/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleminio.config;

import cn.unikue.commonplexus.springutil.property.MinioProperties;
import cn.unikue.commonplexus.springutil.util.MinioConfigWraps;
import cn.unikue.springstarter.multipleminio.config.PrimaryMinioAutoConfiguration;
import io.minio.MinioClient;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.multiple-minio.secondary", name={"endpoint"})
@ConditionalOnClass(value={MinioClient.class})
@AutoConfigureAfter(value={PrimaryMinioAutoConfiguration.class})
public class SecondaryMinioAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-minio.secondary";
    public static final String MINIO_PROPERTIES = "secondaryMinioProperties";
    public static final String MINIO_CLIENT = "secondaryMinioClient";

    @Bean(name={"secondaryMinioProperties"})
    @ConfigurationProperties(prefix="spring.multiple-minio.secondary")
    @ConditionalOnMissingBean(name={"secondaryMinioProperties"})
    public MinioProperties minioProperties() {
        return new MinioProperties();
    }

    @Bean(name={"secondaryMinioClient"})
    @ConditionalOnBean(name={"secondaryMinioProperties"}, value={MinioProperties.class})
    @ConditionalOnMissingBean(name={"secondaryMinioClient"})
    public MinioClient minioClient(@Qualifier(value="secondaryMinioProperties") @NonNull MinioProperties properties) throws Exception {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return MinioConfigWraps.minioClient((MinioProperties)properties);
    }
}

