/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.config;

import cn.unikue.springstarter.multiplerabbit.config.PrimaryRabbitAutoConfiguration;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConfigurationUtils;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit", name={"enabled"}, matchIfMissing=true)
@ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"host"})
@ConditionalOnClass(value={EnableRabbit.class})
@AutoConfigureAfter(value={PrimaryRabbitAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class PrimaryRabbitAnnotationDrivenConfiguration {
    public static final String MESSAGE_RECOVERER = "primaryRabbitMessageRecoverer";
    public static final String SIMPLE_CONTAINER_FACTORY_CONFIGURER = "primaryRabbitSimpleListenerContainerFactoryConfigurer";
    public static final String DIRECT_CONTAINER_FACTORY_CONFIGURER = "primaryRabbitDirectListenerContainerFactoryConfigurer";
    public static final String CONTAINER_FACTORY = "primaryRabbitListenerContainerFactory";

    @Primary
    @Bean(name={"primaryRabbitSimpleListenerContainerFactoryConfigurer"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"listener.type"}, havingValue="simple", matchIfMissing=true)
    @ConditionalOnBean(name={"primaryRabbitProperties"}, value={RabbitProperties.class})
    @ConditionalOnMissingBean(name={"primaryRabbitSimpleListenerContainerFactoryConfigurer"})
    public SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurer(@Qualifier(value="primaryRabbitProperties") @NonNull RabbitProperties properties, @Autowired(required=false) @Qualifier(value="primaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="primaryRabbitMessageRecoverer") @Nullable MessageRecoverer recoverer, @Autowired(required=false) @Qualifier(value="primaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.simpleRabbitListenerContainerFactoryConfigurer(properties, converter, recoverer, customizer);
    }

    @Primary
    @Bean(name={"primaryRabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"listener.type"}, havingValue="simple", matchIfMissing=true)
    @ConditionalOnBean(name={"primaryRabbitSimpleListenerContainerFactoryConfigurer", "primaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"primaryRabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory(@Qualifier(value="primaryRabbitSimpleListenerContainerFactoryConfigurer") @NonNull SimpleRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="primaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        SimpleRabbitListenerContainerFactory containerFactory = new SimpleRabbitListenerContainerFactory();
        configurer.configure(containerFactory, factory);
        return containerFactory;
    }

    @Primary
    @Bean(name={"primaryRabbitDirectListenerContainerFactoryConfigurer"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"listener.type"}, havingValue="direct")
    @ConditionalOnBean(name={"primaryRabbitProperties"}, value={RabbitProperties.class})
    @ConditionalOnMissingBean(name={"primaryRabbitDirectListenerContainerFactoryConfigurer"})
    public DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurer(@Qualifier(value="primaryRabbitProperties") @NonNull RabbitProperties properties, @Autowired(required=false) @Qualifier(value="primaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="primaryRabbitMessageRecoverer") @Nullable MessageRecoverer recoverer, @Autowired(required=false) @Qualifier(value="primaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.directRabbitListenerContainerFactoryConfigurer(properties, converter, recoverer, customizer);
    }

    @Primary
    @Bean(name={"primaryRabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"listener.type"}, havingValue="direct")
    @ConditionalOnBean(name={"primaryRabbitDirectListenerContainerFactoryConfigurer", "primaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"primaryRabbitListenerContainerFactory"})
    public DirectRabbitListenerContainerFactory directRabbitListenerContainerFactory(@Qualifier(value="primaryRabbitDirectListenerContainerFactoryConfigurer") @NonNull DirectRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="primaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        DirectRabbitListenerContainerFactory containerFactory = new DirectRabbitListenerContainerFactory();
        configurer.configure(containerFactory, factory);
        return containerFactory;
    }
}

