/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.config;

import cn.unikue.springstarter.multiplerabbit.config.EnableRabbitAutoConfiguration;
import cn.unikue.springstarter.multiplerabbit.property.MultipleRabbitProperties;
import cn.unikue.springstarter.multiplerabbit.util.CustomExchangeUtils;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConfigurationUtils;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit", name={"enabled"}, matchIfMissing=true)
@ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"host"})
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@AutoConfigureAfter(value={EnableRabbitAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class PrimaryRabbitAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-rabbit.primary";
    public static final String RABBIT_PROPERTIES = "primaryRabbitProperties";
    public static final String CONNECTION_DETAILS = "primaryRabbitConnectionDetails";
    public static final String CREDENTIALS_PROVIDER = "primaryRabbitCredentialsProvider";
    public static final String CREDENTIALS_REFRESH_SERVICE = "primaryRabbitCredentialsRefreshService";
    public static final String SSL_BUNDLES = "primaryRabbitSslBundles";
    public static final String CONNECTION_FACTORY_BEAN_CONFIGURER = "primaryRabbitConnectionFactoryBeanConfigurer";
    public static final String CONNECTION_NAME_STRATEGY = "primaryRabbitConnectionNameStrategy";
    public static final String CACHING_CONNECTION_FACTORY_CONFIGURER = "primaryRabbitCachingConnectionFactoryConfigurer";
    public static final String CONNECTION_FACTORY_CUSTOMIZER = "primaryRabbitConnectionFactoryCustomizer";
    public static final String CONNECTION_FACTORY = "primaryRabbitConnectionFactory";
    public static final String MESSAGE_CONVERTER = "primaryRabbitMessageConverter";
    public static final String RETRY_TEMPLATE_CUSTOMIZER = "primaryRabbitRetryTemplateCustomizer";
    public static final String RABBIT_TEMPLATE_CONFIGURER = "primaryRabbitTemplateConfigurer";
    public static final String RABBIT_TEMPLATE_CUSTOMIZER = "primaryRabbitTemplateCustomizer";
    public static final String RABBIT_TEMPLATE = "primaryRabbitTemplate";
    public static final String RABBIT_MESSAGING_TEMPLATE = "primaryRabbitMessagingTemplate";
    public static final String AMQP_ADMIN = "primaryRabbitAmqpAdmin";
    public static final String DELAYED_EXCHANGE = "primaryRabbitDelayedExchange";

    @Primary
    @Bean(name={"primaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"primaryRabbitProperties"})
    @ConfigurationProperties(prefix="spring.multiple-rabbit.primary")
    public MultipleRabbitProperties rabbitProperties() {
        return new MultipleRabbitProperties();
    }

    @Primary
    @Bean(name={"primaryRabbitConnectionDetails"})
    @ConditionalOnBean(name={"primaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"primaryRabbitConnectionDetails"})
    public RabbitConnectionDetails rabbitConnectionDetails(@Qualifier(value="primaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="primaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitConnectionDetails(properties, bundles);
    }

    @Primary
    @Bean(name={"primaryRabbitConnectionFactoryBeanConfigurer"})
    @ConditionalOnBean(name={"primaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"primaryRabbitConnectionFactoryBeanConfigurer"})
    public RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer(@Qualifier(value="primaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @NonNull ResourceLoader loader, @Autowired(required=false) @Qualifier(value="primaryRabbitConnectionDetails") @Nullable RabbitConnectionDetails details, @Autowired(required=false) @Qualifier(value="primaryRabbitCredentialsProvider") @Nullable CredentialsProvider credentials, @Autowired(required=false) @Qualifier(value="primaryRabbitCredentialsRefreshService") @Nullable CredentialsRefreshService refresh, @Autowired(required=false) @Qualifier(value="primaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitConnectionFactoryBeanConfigurer(properties, loader, details, credentials, refresh, bundles);
    }

    @Primary
    @Bean(name={"primaryRabbitCachingConnectionFactoryConfigurer"})
    @ConditionalOnBean(name={"primaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"primaryRabbitCachingConnectionFactoryConfigurer"})
    public CachingConnectionFactoryConfigurer cachingConnectionFactoryConfigurer(@Qualifier(value="primaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="primaryRabbitConnectionDetails") @Nullable RabbitConnectionDetails details, @Autowired(required=false) @Qualifier(value="primaryRabbitConnectionNameStrategy") @Nullable ConnectionNameStrategy strategy, @Autowired(required=false) @Qualifier(value="primaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.cachingConnectionFactoryConfigurer(properties, details, strategy, bundles);
    }

    @Primary
    @Bean(name={"primaryRabbitConnectionFactory"})
    @ConditionalOnBean(name={"primaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"primaryRabbitConnectionFactory"})
    public CachingConnectionFactory cachingConnectionFactory(@Qualifier(value="primaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Qualifier(value="primaryRabbitConnectionFactoryBeanConfigurer") @NonNull RabbitConnectionFactoryBeanConfigurer rabbitConfigurer, @Qualifier(value="primaryRabbitCachingConnectionFactoryConfigurer") @NonNull CachingConnectionFactoryConfigurer cachingConfigurer, @Autowired(required=false) @Qualifier(value="primaryRabbitConnectionFactoryCustomizer") @Nullable ConnectionFactoryCustomizer customizer) throws Exception {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (rabbitConfigurer == null) {
            throw new NullPointerException("rabbitConfigurer is marked non-null but is null");
        }
        if (cachingConfigurer == null) {
            throw new NullPointerException("cachingConfigurer is marked non-null but is null");
        }
        return RabbitConfigurationUtils.cachingConnectionFactory(properties, rabbitConfigurer, cachingConfigurer, customizer);
    }

    @Primary
    @Bean(name={"primaryRabbitTemplateConfigurer"})
    @ConditionalOnBean(name={"primaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"primaryRabbitTemplateConfigurer"})
    public RabbitTemplateConfigurer rabbitTemplateConfigurer(@Qualifier(value="primaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="primaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="primaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitTemplateConfigurer(properties, converter, customizer);
    }

    @Primary
    @Bean(name={"primaryRabbitTemplate"})
    @ConditionalOnBean(name={"primaryRabbitTemplateConfigurer", "primaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"primaryRabbitTemplate"})
    public RabbitTemplate rabbitTemplate(@Qualifier(value="primaryRabbitTemplateConfigurer") @NonNull RabbitTemplateConfigurer configurer, @Qualifier(value="primaryRabbitConnectionFactory") @NonNull ConnectionFactory factory, @Autowired(required=false) @Qualifier(value="primaryRabbitTemplateCustomizer") @NonNull RabbitTemplateCustomizer customizer) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (customizer == null) {
            throw new NullPointerException("customizer is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitTemplate(configurer, factory, customizer);
    }

    @Primary
    @Bean(name={"primaryRabbitMessagingTemplate"})
    @ConditionalOnBean(name={"primaryRabbitTemplate"}, value={RabbitTemplate.class})
    @ConditionalOnMissingBean(name={"primaryRabbitMessagingTemplate"})
    public RabbitMessagingTemplate rabbitMessagingTemplate(@Qualifier(value="primaryRabbitTemplate") @NonNull RabbitTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return new RabbitMessagingTemplate(template);
    }

    @Primary
    @Bean(name={"primaryRabbitAmqpAdmin"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.primary", name={"dynamic"}, matchIfMissing=true)
    @ConditionalOnBean(name={"primaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"primaryRabbitAmqpAdmin"})
    public AmqpAdmin amqpAdmin(@Qualifier(value="primaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return new RabbitAdmin(factory);
    }

    @Primary
    @Bean(name={"primaryRabbitDelayedExchange"})
    @ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit.primary.delayed-exchange", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.primary.delayed-exchange", name={"name"})
    @ConditionalOnBean(name={"primaryRabbitAmqpAdmin"})
    @ConditionalOnMissingBean(name={"primaryRabbitDelayedExchange"})
    public CustomExchange delayedExchange(@Qualifier(value="primaryRabbitAmqpAdmin") @Nonnull AmqpAdmin amqpAdmin, @Qualifier(value="primaryRabbitProperties") @NonNull MultipleRabbitProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        MultipleRabbitProperties.DelayedExchange prop = properties.getDelayedExchange();
        return CustomExchangeUtils.delayedMessageExchange(amqpAdmin, prop.getName(), prop.getType(), BooleanUtils.isTrue((Boolean)prop.getDurable()), BooleanUtils.isTrue((Boolean)prop.getAutoDelete()));
    }
}

