/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.config;

import cn.unikue.springstarter.multiplerabbit.config.PrimaryRabbitAnnotationDrivenConfiguration;
import cn.unikue.springstarter.multiplerabbit.config.SecondaryRabbitAutoConfiguration;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConfigurationUtils;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit", name={"enabled"}, matchIfMissing=true)
@ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"host"})
@ConditionalOnClass(value={EnableRabbit.class})
@AutoConfigureAfter(value={PrimaryRabbitAnnotationDrivenConfiguration.class, SecondaryRabbitAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class SecondaryRabbitAnnotationDrivenConfiguration {
    public static final String MESSAGE_RECOVERER = "secondaryRabbitMessageRecoverer";
    public static final String SIMPLE_CONTAINER_FACTORY_CONFIGURER = "secondaryRabbitSimpleListenerContainerFactoryConfigurer";
    public static final String DIRECT_CONTAINER_FACTORY_CONFIGURER = "secondaryRabbitDirectListenerContainerFactoryConfigurer";
    public static final String CONTAINER_FACTORY = "secondaryRabbitListenerContainerFactory";

    @Bean(name={"secondaryRabbitSimpleListenerContainerFactoryConfigurer"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"listener.type"}, havingValue="simple", matchIfMissing=true)
    @ConditionalOnBean(name={"secondaryRabbitProperties"}, value={RabbitProperties.class})
    @ConditionalOnMissingBean(name={"secondaryRabbitSimpleListenerContainerFactoryConfigurer"})
    public SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurer(@Qualifier(value="secondaryRabbitProperties") @NonNull RabbitProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="secondaryRabbitMessageRecoverer") @Nullable MessageRecoverer recoverer, @Autowired(required=false) @Qualifier(value="secondaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.simpleRabbitListenerContainerFactoryConfigurer(properties, converter, recoverer, customizer);
    }

    @Bean(name={"secondaryRabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"listener.type"}, havingValue="simple", matchIfMissing=true)
    @ConditionalOnBean(name={"secondaryRabbitSimpleListenerContainerFactoryConfigurer", "secondaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"secondaryRabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory(@Qualifier(value="secondaryRabbitSimpleListenerContainerFactoryConfigurer") @NonNull SimpleRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="secondaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        SimpleRabbitListenerContainerFactory containerFactory = new SimpleRabbitListenerContainerFactory();
        configurer.configure(containerFactory, factory);
        return containerFactory;
    }

    @Bean(name={"secondaryRabbitDirectListenerContainerFactoryConfigurer"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"listener.type"}, havingValue="direct")
    @ConditionalOnBean(name={"secondaryRabbitProperties"}, value={RabbitProperties.class})
    @ConditionalOnMissingBean(name={"secondaryRabbitDirectListenerContainerFactoryConfigurer"})
    public DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurer(@Qualifier(value="secondaryRabbitProperties") @NonNull RabbitProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="secondaryRabbitMessageRecoverer") @Nullable MessageRecoverer recoverer, @Autowired(required=false) @Qualifier(value="secondaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.directRabbitListenerContainerFactoryConfigurer(properties, converter, recoverer, customizer);
    }

    @Bean(name={"secondaryRabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"listener.type"}, havingValue="direct")
    @ConditionalOnBean(name={"secondaryRabbitDirectListenerContainerFactoryConfigurer", "secondaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"secondaryRabbitListenerContainerFactory"})
    public DirectRabbitListenerContainerFactory directRabbitListenerContainerFactory(@Qualifier(value="secondaryRabbitDirectListenerContainerFactoryConfigurer") @NonNull DirectRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="secondaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        DirectRabbitListenerContainerFactory containerFactory = new DirectRabbitListenerContainerFactory();
        configurer.configure(containerFactory, factory);
        return containerFactory;
    }
}

