/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.config;

import cn.unikue.springstarter.multiplerabbit.config.PrimaryRabbitAutoConfiguration;
import cn.unikue.springstarter.multiplerabbit.property.MultipleRabbitProperties;
import cn.unikue.springstarter.multiplerabbit.util.CustomExchangeUtils;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConfigurationUtils;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit", name={"enabled"}, matchIfMissing=true)
@ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"host"})
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@AutoConfigureAfter(value={PrimaryRabbitAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class SecondaryRabbitAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-rabbit.secondary";
    public static final String RABBIT_PROPERTIES = "secondaryRabbitProperties";
    public static final String CONNECTION_DETAILS = "secondaryRabbitConnectionDetails";
    public static final String CREDENTIALS_PROVIDER = "secondaryRabbitCredentialsProvider";
    public static final String CREDENTIALS_REFRESH_SERVICE = "secondaryRabbitCredentialsRefreshService";
    public static final String SSL_BUNDLES = "secondaryRabbitSslBundles";
    public static final String CONNECTION_FACTORY_BEAN_CONFIGURER = "secondaryRabbitConnectionFactoryBeanConfigurer";
    public static final String CONNECTION_NAME_STRATEGY = "secondaryRabbitConnectionNameStrategy";
    public static final String CACHING_CONNECTION_FACTORY_CONFIGURER = "secondaryRabbitCachingConnectionFactoryConfigurer";
    public static final String CONNECTION_FACTORY_CUSTOMIZER = "secondaryRabbitConnectionFactoryCustomizer";
    public static final String CONNECTION_FACTORY = "secondaryRabbitConnectionFactory";
    public static final String MESSAGE_CONVERTER = "secondaryRabbitMessageConverter";
    public static final String RETRY_TEMPLATE_CUSTOMIZER = "secondaryRabbitRetryTemplateCustomizer";
    public static final String RABBIT_TEMPLATE_CONFIGURER = "secondaryRabbitTemplateConfigurer";
    public static final String RABBIT_TEMPLATE_CUSTOMIZER = "primaryRabbitTemplateCustomizer";
    public static final String RABBIT_TEMPLATE = "secondaryRabbitTemplate";
    public static final String RABBIT_MESSAGING_TEMPLATE = "secondaryRabbitMessagingTemplate";
    public static final String AMQP_ADMIN = "secondaryRabbitAmqpAdmin";
    public static final String DELAYED_EXCHANGE = "secondaryRabbitDelayedExchange";

    @Bean(name={"secondaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"secondaryRabbitProperties"})
    @ConfigurationProperties(prefix="spring.multiple-rabbit.secondary")
    public MultipleRabbitProperties rabbitProperties() {
        return new MultipleRabbitProperties();
    }

    @Bean(name={"secondaryRabbitConnectionDetails"})
    @ConditionalOnBean(name={"secondaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"secondaryRabbitConnectionDetails"})
    public RabbitConnectionDetails rabbitConnectionDetails(@Qualifier(value="secondaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitConnectionDetails(properties, bundles);
    }

    @Bean(name={"secondaryRabbitConnectionFactoryBeanConfigurer"})
    @ConditionalOnBean(name={"secondaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"secondaryRabbitConnectionFactoryBeanConfigurer"})
    public RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer(@Qualifier(value="secondaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @NonNull ResourceLoader loader, @Autowired(required=false) @Qualifier(value="secondaryRabbitConnectionDetails") @Nullable RabbitConnectionDetails details, @Autowired(required=false) @Qualifier(value="secondaryRabbitCredentialsProvider") @Nullable CredentialsProvider credentials, @Autowired(required=false) @Qualifier(value="secondaryRabbitCredentialsRefreshService") @Nullable CredentialsRefreshService refresh, @Autowired(required=false) @Qualifier(value="secondaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitConnectionFactoryBeanConfigurer(properties, loader, details, credentials, refresh, bundles);
    }

    @Bean(name={"secondaryRabbitCachingConnectionFactoryConfigurer"})
    @ConditionalOnBean(name={"secondaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"secondaryRabbitCachingConnectionFactoryConfigurer"})
    public CachingConnectionFactoryConfigurer cachingConnectionFactoryConfigurer(@Qualifier(value="secondaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRabbitConnectionDetails") @Nullable RabbitConnectionDetails details, @Autowired(required=false) @Qualifier(value="secondaryRabbitConnectionNameStrategy") @Nullable ConnectionNameStrategy strategy, @Autowired(required=false) @Qualifier(value="secondaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.cachingConnectionFactoryConfigurer(properties, details, strategy, bundles);
    }

    @Bean(name={"secondaryRabbitConnectionFactory"})
    @ConditionalOnBean(name={"secondaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"secondaryRabbitConnectionFactory"})
    public CachingConnectionFactory cachingConnectionFactory(@Qualifier(value="secondaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Qualifier(value="secondaryRabbitConnectionFactoryBeanConfigurer") @NonNull RabbitConnectionFactoryBeanConfigurer rabbitConfigurer, @Qualifier(value="secondaryRabbitCachingConnectionFactoryConfigurer") @NonNull CachingConnectionFactoryConfigurer cachingConfigurer, @Autowired(required=false) @Qualifier(value="secondaryRabbitConnectionFactoryCustomizer") @Nullable ConnectionFactoryCustomizer customizer) throws Exception {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (rabbitConfigurer == null) {
            throw new NullPointerException("rabbitConfigurer is marked non-null but is null");
        }
        if (cachingConfigurer == null) {
            throw new NullPointerException("cachingConfigurer is marked non-null but is null");
        }
        return RabbitConfigurationUtils.cachingConnectionFactory(properties, rabbitConfigurer, cachingConfigurer, customizer);
    }

    @Bean(name={"secondaryRabbitTemplateConfigurer"})
    @ConditionalOnBean(name={"secondaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"secondaryRabbitTemplateConfigurer"})
    public RabbitTemplateConfigurer rabbitTemplateConfigurer(@Qualifier(value="secondaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="secondaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitTemplateConfigurer(properties, converter, customizer);
    }

    @Bean(name={"secondaryRabbitTemplate"})
    @ConditionalOnBean(name={"secondaryRabbitTemplateConfigurer", "secondaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"secondaryRabbitTemplate"})
    public RabbitTemplate rabbitTemplate(@Qualifier(value="secondaryRabbitTemplateConfigurer") @NonNull RabbitTemplateConfigurer configurer, @Qualifier(value="secondaryRabbitConnectionFactory") @NonNull ConnectionFactory factory, @Autowired(required=false) @Qualifier(value="primaryRabbitTemplateCustomizer") @NonNull RabbitTemplateCustomizer customizer) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (customizer == null) {
            throw new NullPointerException("customizer is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitTemplate(configurer, factory, customizer);
    }

    @Bean(name={"secondaryRabbitMessagingTemplate"})
    @ConditionalOnBean(name={"secondaryRabbitTemplate"}, value={RabbitTemplate.class})
    @ConditionalOnMissingBean(name={"secondaryRabbitMessagingTemplate"})
    public RabbitMessagingTemplate rabbitMessagingTemplate(@Qualifier(value="secondaryRabbitTemplate") @NonNull RabbitTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return new RabbitMessagingTemplate(template);
    }

    @Bean(name={"secondaryRabbitAmqpAdmin"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary", name={"dynamic"}, matchIfMissing=true)
    @ConditionalOnBean(name={"secondaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"secondaryRabbitAmqpAdmin"})
    public AmqpAdmin amqpAdmin(@Qualifier(value="secondaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return new RabbitAdmin(factory);
    }

    @Bean(name={"secondaryRabbitDelayedExchange"})
    @ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit.secondary.delayed-exchange", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.secondary.delayed-exchange", name={"name"})
    @ConditionalOnBean(name={"secondaryRabbitAmqpAdmin"})
    @ConditionalOnMissingBean(name={"secondaryRabbitDelayedExchange"})
    public CustomExchange delayedExchange(@Qualifier(value="secondaryRabbitAmqpAdmin") @Nonnull AmqpAdmin amqpAdmin, @Qualifier(value="secondaryRabbitProperties") @NonNull MultipleRabbitProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        MultipleRabbitProperties.DelayedExchange prop = properties.getDelayedExchange();
        return CustomExchangeUtils.delayedMessageExchange(amqpAdmin, prop.getName(), prop.getType(), BooleanUtils.isTrue((Boolean)prop.getDurable()), BooleanUtils.isTrue((Boolean)prop.getAutoDelete()));
    }
}

