/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.config;

import cn.unikue.springstarter.multiplerabbit.config.SecondaryRabbitAnnotationDrivenConfiguration;
import cn.unikue.springstarter.multiplerabbit.config.TertiaryRabbitAutoConfiguration;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConfigurationUtils;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit", name={"enabled"}, matchIfMissing=true)
@ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"host"})
@ConditionalOnClass(value={EnableRabbit.class})
@AutoConfigureAfter(value={SecondaryRabbitAnnotationDrivenConfiguration.class, TertiaryRabbitAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class TertiaryRabbitAnnotationDrivenConfiguration {
    public static final String MESSAGE_RECOVERER = "tertiaryRabbitMessageRecoverer";
    public static final String SIMPLE_CONTAINER_FACTORY_CONFIGURER = "tertiaryRabbitSimpleListenerContainerFactoryConfigurer";
    public static final String DIRECT_CONTAINER_FACTORY_CONFIGURER = "tertiaryRabbitDirectListenerContainerFactoryConfigurer";
    public static final String CONTAINER_FACTORY = "tertiaryRabbitListenerContainerFactory";

    @Bean(name={"tertiaryRabbitSimpleListenerContainerFactoryConfigurer"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"listener.type"}, havingValue="simple", matchIfMissing=true)
    @ConditionalOnBean(name={"tertiaryRabbitProperties"}, value={RabbitProperties.class})
    @ConditionalOnMissingBean(name={"tertiaryRabbitSimpleListenerContainerFactoryConfigurer"})
    public SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurer(@Qualifier(value="tertiaryRabbitProperties") @NonNull RabbitProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="tertiaryRabbitMessageRecoverer") @Nullable MessageRecoverer recoverer, @Autowired(required=false) @Qualifier(value="tertiaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.simpleRabbitListenerContainerFactoryConfigurer(properties, converter, recoverer, customizer);
    }

    @Bean(name={"tertiaryRabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"listener.type"}, havingValue="simple", matchIfMissing=true)
    @ConditionalOnBean(name={"tertiaryRabbitSimpleListenerContainerFactoryConfigurer", "tertiaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory(@Qualifier(value="tertiaryRabbitSimpleListenerContainerFactoryConfigurer") @NonNull SimpleRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="tertiaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        SimpleRabbitListenerContainerFactory containerFactory = new SimpleRabbitListenerContainerFactory();
        configurer.configure(containerFactory, factory);
        return containerFactory;
    }

    @Bean(name={"tertiaryRabbitDirectListenerContainerFactoryConfigurer"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"listener.type"}, havingValue="direct")
    @ConditionalOnBean(name={"tertiaryRabbitProperties"}, value={RabbitProperties.class})
    @ConditionalOnMissingBean(name={"tertiaryRabbitDirectListenerContainerFactoryConfigurer"})
    public DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurer(@Qualifier(value="tertiaryRabbitProperties") @NonNull RabbitProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="tertiaryRabbitMessageRecoverer") @Nullable MessageRecoverer recoverer, @Autowired(required=false) @Qualifier(value="tertiaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.directRabbitListenerContainerFactoryConfigurer(properties, converter, recoverer, customizer);
    }

    @Bean(name={"tertiaryRabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"listener.type"}, havingValue="direct")
    @ConditionalOnBean(name={"tertiaryRabbitDirectListenerContainerFactoryConfigurer", "tertiaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitListenerContainerFactory"})
    public DirectRabbitListenerContainerFactory directRabbitListenerContainerFactory(@Qualifier(value="tertiaryRabbitDirectListenerContainerFactoryConfigurer") @NonNull DirectRabbitListenerContainerFactoryConfigurer configurer, @Qualifier(value="tertiaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        DirectRabbitListenerContainerFactory containerFactory = new DirectRabbitListenerContainerFactory();
        configurer.configure(containerFactory, factory);
        return containerFactory;
    }
}

