/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.config;

import cn.unikue.springstarter.multiplerabbit.config.SecondaryRabbitAutoConfiguration;
import cn.unikue.springstarter.multiplerabbit.property.MultipleRabbitProperties;
import cn.unikue.springstarter.multiplerabbit.util.CustomExchangeUtils;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConfigurationUtils;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit", name={"enabled"}, matchIfMissing=true)
@ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"host"})
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@AutoConfigureAfter(value={SecondaryRabbitAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class TertiaryRabbitAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-rabbit.tertiary";
    public static final String RABBIT_PROPERTIES = "tertiaryRabbitProperties";
    public static final String CONNECTION_DETAILS = "tertiaryRabbitConnectionDetails";
    public static final String CREDENTIALS_PROVIDER = "tertiaryRabbitCredentialsProvider";
    public static final String CREDENTIALS_REFRESH_SERVICE = "tertiaryRabbitCredentialsRefreshService";
    public static final String SSL_BUNDLES = "tertiaryRabbitSslBundles";
    public static final String CONNECTION_FACTORY_BEAN_CONFIGURER = "tertiaryRabbitConnectionFactoryBeanConfigurer";
    public static final String CONNECTION_NAME_STRATEGY = "tertiaryRabbitConnectionNameStrategy";
    public static final String CACHING_CONNECTION_FACTORY_CONFIGURER = "tertiaryRabbitCachingConnectionFactoryConfigurer";
    public static final String CONNECTION_FACTORY_CUSTOMIZER = "tertiaryRabbitConnectionFactoryCustomizer";
    public static final String CONNECTION_FACTORY = "tertiaryRabbitConnectionFactory";
    public static final String MESSAGE_CONVERTER = "tertiaryRabbitMessageConverter";
    public static final String RETRY_TEMPLATE_CUSTOMIZER = "tertiaryRabbitRetryTemplateCustomizer";
    public static final String RABBIT_TEMPLATE_CONFIGURER = "tertiaryRabbitTemplateConfigurer";
    public static final String RABBIT_TEMPLATE_CUSTOMIZER = "primaryRabbitTemplateCustomizer";
    public static final String RABBIT_TEMPLATE = "tertiaryRabbitTemplate";
    public static final String RABBIT_MESSAGING_TEMPLATE = "tertiaryRabbitMessagingTemplate";
    public static final String AMQP_ADMIN = "tertiaryRabbitAmqpAdmin";
    public static final String DELAYED_EXCHANGE = "tertiaryRabbitDelayedExchange";

    @Bean(name={"tertiaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitProperties"})
    @ConfigurationProperties(prefix="spring.multiple-rabbit.tertiary")
    public MultipleRabbitProperties rabbitProperties() {
        return new MultipleRabbitProperties();
    }

    @Bean(name={"tertiaryRabbitConnectionDetails"})
    @ConditionalOnBean(name={"tertiaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitConnectionDetails"})
    public RabbitConnectionDetails rabbitConnectionDetails(@Qualifier(value="tertiaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitConnectionDetails(properties, bundles);
    }

    @Bean(name={"tertiaryRabbitConnectionFactoryBeanConfigurer"})
    @ConditionalOnBean(name={"tertiaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitConnectionFactoryBeanConfigurer"})
    public RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer(@Qualifier(value="tertiaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @NonNull ResourceLoader loader, @Autowired(required=false) @Qualifier(value="tertiaryRabbitConnectionDetails") @Nullable RabbitConnectionDetails details, @Autowired(required=false) @Qualifier(value="tertiaryRabbitCredentialsProvider") @Nullable CredentialsProvider credentials, @Autowired(required=false) @Qualifier(value="tertiaryRabbitCredentialsRefreshService") @Nullable CredentialsRefreshService refresh, @Autowired(required=false) @Qualifier(value="tertiaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitConnectionFactoryBeanConfigurer(properties, loader, details, credentials, refresh, bundles);
    }

    @Bean(name={"tertiaryRabbitCachingConnectionFactoryConfigurer"})
    @ConditionalOnBean(name={"tertiaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitCachingConnectionFactoryConfigurer"})
    public CachingConnectionFactoryConfigurer cachingConnectionFactoryConfigurer(@Qualifier(value="tertiaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRabbitConnectionDetails") @Nullable RabbitConnectionDetails details, @Autowired(required=false) @Qualifier(value="tertiaryRabbitConnectionNameStrategy") @Nullable ConnectionNameStrategy strategy, @Autowired(required=false) @Qualifier(value="tertiaryRabbitSslBundles") @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.cachingConnectionFactoryConfigurer(properties, details, strategy, bundles);
    }

    @Bean(name={"tertiaryRabbitConnectionFactory"})
    @ConditionalOnBean(name={"tertiaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitConnectionFactory"})
    public CachingConnectionFactory cachingConnectionFactory(@Qualifier(value="tertiaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Qualifier(value="tertiaryRabbitConnectionFactoryBeanConfigurer") @NonNull RabbitConnectionFactoryBeanConfigurer rabbitConfigurer, @Qualifier(value="tertiaryRabbitCachingConnectionFactoryConfigurer") @NonNull CachingConnectionFactoryConfigurer cachingConfigurer, @Autowired(required=false) @Qualifier(value="tertiaryRabbitConnectionFactoryCustomizer") @Nullable ConnectionFactoryCustomizer customizer) throws Exception {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (rabbitConfigurer == null) {
            throw new NullPointerException("rabbitConfigurer is marked non-null but is null");
        }
        if (cachingConfigurer == null) {
            throw new NullPointerException("cachingConfigurer is marked non-null but is null");
        }
        return RabbitConfigurationUtils.cachingConnectionFactory(properties, rabbitConfigurer, cachingConfigurer, customizer);
    }

    @Bean(name={"tertiaryRabbitTemplateConfigurer"})
    @ConditionalOnBean(name={"tertiaryRabbitProperties"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitTemplateConfigurer"})
    public RabbitTemplateConfigurer rabbitTemplateConfigurer(@Qualifier(value="tertiaryRabbitProperties") @NonNull MultipleRabbitProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRabbitMessageConverter") @Nullable MessageConverter converter, @Autowired(required=false) @Qualifier(value="tertiaryRabbitRetryTemplateCustomizer") @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitTemplateConfigurer(properties, converter, customizer);
    }

    @Bean(name={"tertiaryRabbitTemplate"})
    @ConditionalOnBean(name={"tertiaryRabbitTemplateConfigurer", "tertiaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitTemplate"})
    public RabbitTemplate rabbitTemplate(@Qualifier(value="tertiaryRabbitTemplateConfigurer") @NonNull RabbitTemplateConfigurer configurer, @Qualifier(value="tertiaryRabbitConnectionFactory") @NonNull ConnectionFactory factory, @Autowired(required=false) @Qualifier(value="primaryRabbitTemplateCustomizer") @NonNull RabbitTemplateCustomizer customizer) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (customizer == null) {
            throw new NullPointerException("customizer is marked non-null but is null");
        }
        return RabbitConfigurationUtils.rabbitTemplate(configurer, factory, customizer);
    }

    @Bean(name={"tertiaryRabbitMessagingTemplate"})
    @ConditionalOnBean(name={"tertiaryRabbitTemplate"}, value={RabbitTemplate.class})
    @ConditionalOnMissingBean(name={"tertiaryRabbitMessagingTemplate"})
    public RabbitMessagingTemplate rabbitMessagingTemplate(@Qualifier(value="tertiaryRabbitTemplate") @NonNull RabbitTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return new RabbitMessagingTemplate(template);
    }

    @Bean(name={"tertiaryRabbitAmqpAdmin"})
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary", name={"dynamic"}, matchIfMissing=true)
    @ConditionalOnBean(name={"tertiaryRabbitConnectionFactory"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitAmqpAdmin"})
    public AmqpAdmin amqpAdmin(@Qualifier(value="tertiaryRabbitConnectionFactory") @NonNull ConnectionFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return new RabbitAdmin(factory);
    }

    @Bean(name={"tertiaryRabbitDelayedExchange"})
    @ConditionalOnBooleanProperty(prefix="spring.multiple-rabbit.tertiary.delayed-exchange", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnProperty(prefix="spring.multiple-rabbit.tertiary.delayed-exchange", name={"name"})
    @ConditionalOnBean(name={"tertiaryRabbitAmqpAdmin"})
    @ConditionalOnMissingBean(name={"tertiaryRabbitDelayedExchange"})
    public CustomExchange delayedExchange(@Qualifier(value="tertiaryRabbitAmqpAdmin") @Nonnull AmqpAdmin amqpAdmin, @Qualifier(value="tertiaryRabbitProperties") @NonNull MultipleRabbitProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        MultipleRabbitProperties.DelayedExchange prop = properties.getDelayedExchange();
        return CustomExchangeUtils.delayedMessageExchange(amqpAdmin, prop.getName(), prop.getType(), BooleanUtils.isTrue((Boolean)prop.getDurable()), BooleanUtils.isTrue((Boolean)prop.getAutoDelete()));
    }
}

