/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multiplerabbit.util;

import cn.unikue.springstarter.multiplerabbit.enumeration.RabbitExchangeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;

public abstract class CustomExchangeUtils {
    @Nullable
    public static CustomExchange delayedMessageExchange(@Nonnull AmqpAdmin admin, @Nonnull String name, @Nullable RabbitExchangeType type, boolean durable, boolean autoDelete) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(1);
        args.put("x-delayed-type", type != null ? type.getValue() : RabbitExchangeType.DIRECT.getValue());
        CustomExchange exchange = new CustomExchange(name, "x-delayed-message", durable, autoDelete, args);
        admin.declareExchange((Exchange)exchange);
        return exchange;
    }
}

