/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import cn.unikue.commonplexus.springutil.support.SingletonObjectProvider;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.PropertiesRabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.io.ResourceLoader;

public abstract class RabbitConfigurationUtils
extends RabbitAutoConfiguration {
    @Nonnull
    public static RabbitConnectionDetails rabbitConnectionDetails(@NonNull RabbitProperties properties, @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return new PropertiesRabbitConnectionDetails(properties, bundles);
    }

    @Nonnull
    public static RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer(@NonNull RabbitProperties properties, @NonNull ResourceLoader loader, @Nullable RabbitConnectionDetails details, @Nullable CredentialsProvider credentials, @Nullable CredentialsRefreshService refresh, @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        RabbitConnectionDetails alias = (RabbitConnectionDetails)ObjectUtils.defaultIfNull((Object)details, (Object)RabbitConfigurationUtils.rabbitConnectionDetails(properties, bundles));
        return new RabbitAutoConfiguration.RabbitConnectionFactoryCreator(properties).rabbitConnectionFactoryBeanConfigurer(loader, alias, (ObjectProvider)SingletonObjectProvider.ofNullable((Object)credentials), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)refresh));
    }

    @Nonnull
    public static CachingConnectionFactoryConfigurer cachingConnectionFactoryConfigurer(@NonNull RabbitProperties properties, @Nullable RabbitConnectionDetails details, @Nullable ConnectionNameStrategy strategy, @Nullable SslBundles bundles) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        RabbitConnectionDetails alias = (RabbitConnectionDetails)ObjectUtils.defaultIfNull((Object)details, (Object)RabbitConfigurationUtils.rabbitConnectionDetails(properties, bundles));
        return new RabbitAutoConfiguration.RabbitConnectionFactoryCreator(properties).rabbitConnectionFactoryConfigurer(alias, (ObjectProvider)SingletonObjectProvider.ofNullable((Object)strategy));
    }

    @NonNull
    public static CachingConnectionFactory cachingConnectionFactory(@NonNull RabbitProperties properties, @NonNull RabbitConnectionFactoryBeanConfigurer rabbitConfigurer, @NonNull CachingConnectionFactoryConfigurer cachingConfigurer, @Nullable ConnectionFactoryCustomizer customizer) throws Exception {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (rabbitConfigurer == null) {
            throw new NullPointerException("rabbitConfigurer is marked non-null but is null");
        }
        if (cachingConfigurer == null) {
            throw new NullPointerException("cachingConfigurer is marked non-null but is null");
        }
        return new RabbitAutoConfiguration.RabbitConnectionFactoryCreator(properties).rabbitConnectionFactory(rabbitConfigurer, cachingConfigurer, (ObjectProvider)SingletonObjectProvider.ofNullable((Object)customizer));
    }

    @NonNull
    public static RabbitTemplateConfigurer rabbitTemplateConfigurer(@NonNull RabbitProperties properties, @Nullable MessageConverter converter, @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return new RabbitAutoConfiguration.RabbitTemplateConfiguration().rabbitTemplateConfigurer(properties, (ObjectProvider)SingletonObjectProvider.ofNullable((Object)converter), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)customizer));
    }

    @NonNull
    public static RabbitTemplate rabbitTemplate(@NonNull RabbitTemplateConfigurer configurer, @NonNull ConnectionFactory factory, @Nullable RabbitTemplateCustomizer customizer) {
        if (configurer == null) {
            throw new NullPointerException("configurer is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return new RabbitAutoConfiguration.RabbitTemplateConfiguration().rabbitTemplate(configurer, factory, (ObjectProvider)SingletonObjectProvider.ofNullable((Object)customizer));
    }

    @NonNull
    public static SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurer(@NonNull RabbitProperties properties, @Nullable MessageConverter converter, @Nullable MessageRecoverer recoverer, @Nullable RabbitRetryTemplateCustomizer retryCustomizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        RabbitAnnotationDrivenConfiguration configuration = new RabbitAnnotationDrivenConfiguration((ObjectProvider)SingletonObjectProvider.ofNullable((Object)converter), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)recoverer), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)retryCustomizer), properties);
        return configuration.simpleRabbitListenerContainerFactoryConfigurer();
    }

    @NonNull
    public static SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory(@NonNull RabbitProperties properties, @Nullable MessageConverter converter, @Nullable MessageRecoverer recoverer, @Nullable RabbitRetryTemplateCustomizer retryCustomizer, @NonNull ConnectionFactory factory, @Nullable ContainerCustomizer<SimpleMessageListenerContainer> containerCustomizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        RabbitAnnotationDrivenConfiguration configuration = new RabbitAnnotationDrivenConfiguration((ObjectProvider)SingletonObjectProvider.ofNullable((Object)converter), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)recoverer), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)retryCustomizer), properties);
        SimpleRabbitListenerContainerFactoryConfigurer configurer = configuration.simpleRabbitListenerContainerFactoryConfigurer();
        return configuration.simpleRabbitListenerContainerFactory(configurer, factory, (ObjectProvider)SingletonObjectProvider.ofNullable(containerCustomizer));
    }

    @NonNull
    public static DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurer(@NonNull RabbitProperties properties, @Nullable MessageConverter converter, @Nullable MessageRecoverer recoverer, @Nullable RabbitRetryTemplateCustomizer customizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        RabbitAnnotationDrivenConfiguration configuration = new RabbitAnnotationDrivenConfiguration((ObjectProvider)SingletonObjectProvider.ofNullable((Object)converter), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)recoverer), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)customizer), properties);
        return configuration.directRabbitListenerContainerFactoryConfigurer();
    }

    @NonNull
    public static DirectRabbitListenerContainerFactory directRabbitListenerContainerFactory(@NonNull RabbitProperties properties, @Nullable MessageConverter converter, @Nullable MessageRecoverer recoverer, @Nullable RabbitRetryTemplateCustomizer retryCustomizer, @NonNull ConnectionFactory factory, @Nullable ContainerCustomizer<DirectMessageListenerContainer> containerCustomizer) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        RabbitAnnotationDrivenConfiguration configuration = new RabbitAnnotationDrivenConfiguration((ObjectProvider)SingletonObjectProvider.ofNullable((Object)converter), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)recoverer), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)retryCustomizer), properties);
        DirectRabbitListenerContainerFactoryConfigurer configurer = configuration.directRabbitListenerContainerFactoryConfigurer();
        return configuration.directRabbitListenerContainerFactory(configurer, factory, (ObjectProvider)SingletonObjectProvider.ofNullable(containerCustomizer));
    }
}

