/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.commonplexus.springcondition.annotation.ConditionalOnAnyProperties;
import cn.unikue.commonplexus.springutil.util.JacksonRedisWraps;
import cn.unikue.commonplexus.springutil.util.RedisConfigWraps;
import cn.unikue.springstarter.multipleredis.facade.RedisTemplateCustomizer;
import cn.unikue.springstarter.multipleredis.facade.StringRedisTemplateCustomizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.pool2.ObjectPool;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.JedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientOptionsBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.SimpleRedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true)
@ConditionalOnAnyProperties(value={@ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"url"}), @ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"host"})})
@ConditionalOnClass(value={RedisOperations.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class})
@Import(value={Entry.class, Lettuce.class, Jedis.class, Stage.class})
public class PrimaryRedisAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-redis.primary";
    public static final String REDIS_PROPERTIES = "primaryRedisProperties";
    public static final String CONNECTION_DETAILS = "primaryRedisConnectionDetails";
    public static final String STANDALONE_CONFIGURATION = "primaryRedisStandaloneConfiguration";
    public static final String SENTINEL_CONFIGURATION = "primaryRedisSentinelConfiguration";
    public static final String CLUSTER_CONFIGURATION = "primaryRedisClusterConfiguration";
    public static final String SSL_BUNDLES = "primaryRedisSslBundles";
    public static final String LETTUCE_CLIENT_CONFIGURATION_CUSTOMIZER = "primaryLettuceClientConfigurationCustomizer";
    public static final String LETTUCE_CLIENT_OPTION_CUSTOMIZER = "primaryLettuceClientOptionCustomizer";
    public static final String LETTUCE_CLIENT_RESOURCES = "primaryLettuceClientResources";
    public static final String JEDIS_CLIENT_CUSTOMIZER = "primaryJedisClientCustomizer";
    public static final String CONNECTION_FACTORY = "primaryRedisConnectionFactory";
    public static final String OBJECT_REDIS_TEMPLATE = "primaryObjectRedisTemplate";
    public static final String SESSION_REDIS_TEMPLATE = "primarySessionRedisTemplate";
    public static final String STRING_REDIS_TEMPLATE = "primaryStringRedisTemplate";

    @Order(value=3)
    static class Stage {
        Stage() {
        }

        @Primary
        @Bean(name={"primaryObjectRedisTemplate", "redisTemplate"})
        @ConditionalOnBean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"primaryObjectRedisTemplate"})
        @ConditionalOnMissingClass(value={"com.fasterxml.jackson.databind.ObjectMapper"})
        public RedisTemplate<Object, Object> classicObjectRedisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers) {
            RedisTemplate template = new RedisAutoConfiguration().redisTemplate(factory);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, PrimaryRedisAutoConfiguration.OBJECT_REDIS_TEMPLATE, "redisTemplate"));
            template.afterPropertiesSet();
            return template;
        }

        @Primary
        @Bean(name={"primaryObjectRedisTemplate", "redisTemplate"})
        @ConditionalOnBean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnClass(value={ObjectMapper.class})
        @ConditionalOnMissingBean(name={"primaryObjectRedisTemplate"})
        public RedisTemplate<Object, Object> jasksonObjectRedisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers, @Nonnull ObjectProvider<JacksonProperties> properties) {
            RedisTemplate template = JacksonRedisWraps.objectObjectRedisTemplate((RedisConnectionFactory)factory, (JacksonProperties)((JacksonProperties)properties.getIfAvailable()));
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, PrimaryRedisAutoConfiguration.OBJECT_REDIS_TEMPLATE, "redisTemplate"));
            template.afterPropertiesSet();
            return template;
        }

        @Primary
        @Bean(name={"primaryStringRedisTemplate", "stringRedisTemplate"})
        @ConditionalOnBean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"primaryStringRedisTemplate"})
        public StringRedisTemplate stringRedisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<StringRedisTemplateCustomizer> customizers) {
            StringRedisTemplate template = new RedisAutoConfiguration().stringRedisTemplate(factory);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, PrimaryRedisAutoConfiguration.STRING_REDIS_TEMPLATE, "stringRedisTemplate"));
            template.afterPropertiesSet();
            return template;
        }

        @Primary
        @Bean(name={"primarySessionRedisTemplate"})
        @ConditionalOnBean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"primarySessionRedisTemplate"})
        @ConditionalOnMissingClass(value={"com.fasterxml.jackson.databind.ObjectMapper"})
        public RedisTemplate<String, Object> classicSessionRedisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers) {
            RedisTemplate template = RedisConfigWraps.redisTemplate((RedisConnectionFactory)factory, (RedisSerializer)RedisSerializer.string(), (RedisSerializer)RedisSerializer.java());
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, PrimaryRedisAutoConfiguration.SESSION_REDIS_TEMPLATE));
            return template;
        }

        @Primary
        @Bean(name={"primarySessionRedisTemplate"})
        @ConditionalOnBean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnClass(value={ObjectMapper.class})
        @ConditionalOnMissingBean(name={"primarySessionRedisTemplate"})
        public RedisTemplate<String, Object> jasksonSessionRedisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers, @Nonnull ObjectProvider<JacksonProperties> properties) {
            Jackson2JsonRedisSerializer valueSerializer = JacksonRedisWraps.jsonObjectSerializer((JacksonProperties)((JacksonProperties)properties.getIfAvailable()));
            RedisTemplate template = RedisConfigWraps.redisTemplate((RedisConnectionFactory)factory, (RedisSerializer)RedisSerializer.string(), (RedisSerializer)valueSerializer);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, PrimaryRedisAutoConfiguration.SESSION_REDIS_TEMPLATE));
            return template;
        }
    }

    @ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"client-type"}, havingValue="jedis", matchIfMissing=true)
    @ConditionalOnClass(value={ObjectPool.class, redis.clients.jedis.Jedis.class})
    @Order(value=2)
    static class Jedis {
        Jedis() {
        }

        @Primary
        @Bean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnBean(name={"primaryRedisProperties"})
        @ConditionalOnMissingBean(name={"primaryRedisConnectionFactory"}, value={RedisConnectionFactory.class})
        public JedisConnectionFactory redisConnectionFactory(@Qualifier(value="primaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="primaryRedisConnectionDetails") @Nullable RedisConnectionDetails details, @Autowired(required=false) @Qualifier(value="primaryRedisStandaloneConfiguration") @Nullable RedisStandaloneConfiguration standalone, @Autowired(required=false) @Qualifier(value="primaryRedisSentinelConfiguration") @Nullable RedisSentinelConfiguration sentinel, @Autowired(required=false) @Qualifier(value="primaryRedisClusterConfiguration") @Nullable RedisClusterConfiguration cluster, @Autowired(required=false) @Qualifier(value="primaryRedisSslBundles") @Nullable SslBundles bundles, @Autowired(required=false) @Qualifier(value="primaryJedisClientCustomizer") @Nullable JedisClientConfigurationBuilderCustomizer customizer) {
            return JedisConfigurationUtils.redisConnectionFactory(properties, details, standalone, sentinel, cluster, bundles, customizer);
        }
    }

    @ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"client-type"}, havingValue="lettuce", matchIfMissing=true)
    @ConditionalOnClass(value={RedisClient.class})
    @Order(value=1)
    static class Lettuce {
        Lettuce() {
        }

        @Primary
        @Bean(name={"primaryLettuceClientResources"}, destroyMethod="shutdown")
        @ConditionalOnMissingBean(name={"primaryLettuceClientResources"}, value={ClientResources.class})
        public DefaultClientResources lettuceClientResources() {
            return DefaultClientResources.create();
        }

        @Primary
        @Bean(name={"primaryRedisConnectionFactory"})
        @ConditionalOnBean(name={"primaryRedisProperties", "primaryLettuceClientResources"})
        @ConditionalOnMissingBean(name={"primaryRedisConnectionFactory"}, value={RedisConnectionFactory.class})
        public LettuceConnectionFactory redisConnectionFactory(@Qualifier(value="primaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="primaryRedisConnectionDetails") @Nullable RedisConnectionDetails details, @Autowired(required=false) @Qualifier(value="primaryRedisStandaloneConfiguration") @Nullable RedisStandaloneConfiguration standalone, @Autowired(required=false) @Qualifier(value="primaryRedisSentinelConfiguration") @Nullable RedisSentinelConfiguration sentinel, @Autowired(required=false) @Qualifier(value="primaryRedisClusterConfiguration") @Nullable RedisClusterConfiguration cluster, @Autowired(required=false) @Qualifier(value="primaryRedisSslBundles") @Nullable SslBundles bundles, @Autowired(required=false) @Qualifier(value="primaryLettuceClientConfigurationCustomizer") @Nullable LettuceClientConfigurationBuilderCustomizer configCustomizer, @Autowired(required=false) @Qualifier(value="primaryLettuceClientOptionCustomizer") @Nullable LettuceClientOptionsBuilderCustomizer optionCustomizer, @Qualifier(value="primaryLettuceClientResources") @Nonnull ClientResources resources) {
            return LettuceConfigurationUtils.redisConnectionFactory(properties, details, standalone, sentinel, cluster, bundles, configCustomizer, optionCustomizer, resources);
        }
    }

    @Order(value=0)
    static class Entry {
        Entry() {
        }

        @Primary
        @Bean(name={"primaryRedisProperties"})
        @ConditionalOnMissingBean(name={"primaryRedisProperties"})
        @ConfigurationProperties(prefix="spring.multiple-redis.primary")
        public RedisProperties redisProperties() {
            return new RedisProperties();
        }

        @Primary
        @Bean(name={"primaryRedisConnectionDetails"})
        @ConditionalOnBean(name={"primaryRedisProperties"})
        @ConditionalOnMissingBean(name={"primaryRedisConnectionDetails"})
        public RedisConnectionDetails redisConnectionDetails(@Qualifier(value="primaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="primaryRedisSslBundles") @Nullable SslBundles bundles) {
            return RedisConfigurationUtils.redisConnectionDetails(properties, bundles);
        }

        @Primary
        @Bean(name={"primaryRedisStandaloneConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"standalone"}, matchIfMissing=true)
        @ConditionalOnBean(name={"primaryRedisProperties"})
        @ConditionalOnMissingBean(name={"primaryRedisStandaloneConfiguration"})
        public RedisStandaloneConfiguration redisStandaloneConfiguration(@Qualifier(value="primaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisStandaloneConfiguration();
        }

        @Primary
        @Bean(name={"primaryRedisSentinelConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"sentinel"})
        @ConditionalOnBean(name={"primaryRedisProperties"})
        @ConditionalOnMissingBean(name={"primaryRedisSentinelConfiguration"})
        public RedisSentinelConfiguration redisSentinelConfiguration(@Qualifier(value="primaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisSentinelConfiguration();
        }

        @Primary
        @Bean(name={"primaryRedisClusterConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.primary", name={"cluster"})
        @ConditionalOnBean(name={"primaryRedisProperties"})
        @ConditionalOnMissingBean(name={"primaryRedisClusterConfiguration"})
        public RedisClusterConfiguration redisClusterConfiguration(@Qualifier(value="primaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisClusterConfiguration();
        }
    }
}

