/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.commonplexus.springcondition.annotation.ConditionalOnAllBooleanProperties;
import cn.unikue.commonplexus.springutil.util.RedisConfigWraps;
import cn.unikue.springstarter.cacheexpiry.resolver.impl.RedisExpiryCacheResolver;
import cn.unikue.springstarter.multipleredis.config.PrimaryRedisAutoConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAllBooleanProperties(value={@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true), @ConditionalOnBooleanProperty(prefix="spring.multiple-redis.primary", name={"cache-enabled"}, matchIfMissing=true)})
@ConditionalOnProperty(prefix="spring.cache", name={"type"}, havingValue="redis", matchIfMissing=true)
@ConditionalOnBean(value={CacheAspectSupport.class, CacheProperties.class})
@ConditionalOnClass(value={CacheManager.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, PrimaryRedisAutoConfiguration.class})
@AutoConfigureBefore(name={"cn.unikue.springstarter.cacheexpiry.config.RedisExpiryCacheConfiguration"})
public class PrimaryRedisCacheConfiguration {
    public static final String CACHE_MANAGER = "primaryRedisCacheManager";
    public static final String CACHE_RESOLVER = "primaryRedisCacheResolver";

    @Primary
    @Bean(name={"primaryRedisCacheManager"})
    @ConditionalOnBean(name={"primaryRedisConnectionFactory"})
    @ConditionalOnMissingBean(name={"primaryRedisCacheManager"})
    public CacheManager cacheManager(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull CacheProperties cacheProperties, @Nullable JacksonProperties jacksonProperties) {
        return RedisConfigWraps.cacheManager((RedisConnectionFactory)factory, (CacheProperties)cacheProperties, (JacksonProperties)jacksonProperties);
    }

    @Primary
    @Bean(name={"primaryRedisCacheResolver"})
    @ConditionalOnClass(value={RedisExpiryCacheResolver.class})
    @ConditionalOnBean(name={"primaryRedisCacheManager"})
    @ConditionalOnMissingBean(name={"primaryRedisCacheResolver"})
    public CacheResolver cacheResolver(@Qualifier(value="primaryRedisCacheManager") @Nonnull CacheManager cacheManager) {
        return new RedisExpiryCacheResolver(cacheManager);
    }
}

