/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.springstarter.multipleredis.config.PrimaryRedisAutoConfiguration;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.data.redis.core.RedisOperations;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={RedisOperations.class, Flux.class})
@ConditionalOnBean(name={"primaryRedisConnectionFactory"}, value={ReactiveRedisConnectionFactory.class})
@AutoConfigureAfter(value={PrimaryRedisAutoConfiguration.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class})
public class PrimaryRedisReactiveConfiguration {
    public static final String DEFAULT_REACTIVE_REDIS_TEMPLATE = "reactiveRedisTemplate";
    public static final String DEFAULT_REACTIVE_STRING_REDIS_TEMPLATE = "reactiveStringRedisTemplate";
    public static final String REACTIVE_REDIS_TEMPLATE = "primaryReactiveRedisTemplate";
    public static final String REACTIVE_STRING_REDIS_TEMPLATE = "primaryReactiveStringRedisTemplate";

    @Primary
    @Bean(name={"primaryReactiveRedisTemplate", "reactiveRedisTemplate"})
    @ConditionalOnMissingBean(name={"primaryReactiveRedisTemplate"})
    public ReactiveRedisTemplate<Object, Object> redisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull ReactiveRedisConnectionFactory factory, @Nonnull ResourceLoader loader) {
        return new RedisReactiveAutoConfiguration().reactiveRedisTemplate(factory, loader);
    }

    @Primary
    @Bean(name={"primaryReactiveStringRedisTemplate", "reactiveStringRedisTemplate"})
    @ConditionalOnMissingBean(name={"primaryReactiveStringRedisTemplate"})
    public ReactiveStringRedisTemplate stringRedisTemplate(@Qualifier(value="primaryRedisConnectionFactory") @Nonnull ReactiveRedisConnectionFactory factory) {
        return new RedisReactiveAutoConfiguration().reactiveStringRedisTemplate(factory);
    }
}

