/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.commonplexus.springcondition.annotation.ConditionalOnAnyProperties;
import cn.unikue.commonplexus.springutil.util.JacksonRedisWraps;
import cn.unikue.commonplexus.springutil.util.RedisConfigWraps;
import cn.unikue.springstarter.multipleredis.config.PrimaryRedisAutoConfiguration;
import cn.unikue.springstarter.multipleredis.facade.RedisTemplateCustomizer;
import cn.unikue.springstarter.multipleredis.facade.StringRedisTemplateCustomizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.pool2.ObjectPool;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.JedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientOptionsBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.SimpleRedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true)
@ConditionalOnAnyProperties(value={@ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"url"}), @ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"host"})})
@ConditionalOnClass(value={RedisOperations.class})
@AutoConfigureAfter(value={PrimaryRedisAutoConfiguration.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class})
@Import(value={Entry.class, Lettuce.class, Jedis.class, Stage.class})
public class SecondaryRedisAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-redis.secondary";
    public static final String REDIS_PROPERTIES = "secondaryRedisProperties";
    public static final String CONNECTION_DETAILS = "secondaryRedisConnectionDetails";
    public static final String STANDALONE_CONFIGURATION = "secondaryRedisStandaloneConfiguration";
    public static final String SENTINEL_CONFIGURATION = "secondaryRedisSentinelConfiguration";
    public static final String CLUSTER_CONFIGURATION = "secondaryRedisClusterConfiguration";
    public static final String SSL_BUNDLES = "secondaryRedisSslBundles";
    public static final String LETTUCE_CLIENT_CONFIGURATION_CUSTOMIZER = "secondaryLettuceClientConfigurationCustomizer";
    public static final String LETTUCE_CLIENT_OPTION_CUSTOMIZER = "secondaryLettuceClientOptionCustomizer";
    public static final String LETTUCE_CLIENT_RESOURCES = "secondaryLettuceClientResources";
    public static final String JEDIS_CLIENT_CUSTOMIZER = "secondaryJedisClientCustomizer";
    public static final String CONNECTION_FACTORY = "secondaryRedisConnectionFactory";
    public static final String OBJECT_REDIS_TEMPLATE = "secondaryObjectRedisTemplate";
    public static final String SESSION_REDIS_TEMPLATE = "secondarySessionRedisTemplate";
    public static final String STRING_REDIS_TEMPLATE = "secondaryStringRedisTemplate";

    @Order(value=3)
    static class Stage {
        Stage() {
        }

        @Bean(name={"secondaryObjectRedisTemplate"})
        @ConditionalOnBean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"secondaryObjectRedisTemplate"})
        @ConditionalOnMissingClass(value={"com.fasterxml.jackson.databind.ObjectMapper"})
        public RedisTemplate<Object, Object> classicObjectRedisTemplate(@Qualifier(value="secondaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers) {
            RedisTemplate template = new RedisAutoConfiguration().redisTemplate(factory);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, SecondaryRedisAutoConfiguration.OBJECT_REDIS_TEMPLATE));
            template.afterPropertiesSet();
            return template;
        }

        @Bean(name={"secondaryObjectRedisTemplate"})
        @ConditionalOnBean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnClass(value={ObjectMapper.class})
        @ConditionalOnMissingBean(name={"secondaryObjectRedisTemplate"})
        public RedisTemplate<Object, Object> jacksonObjectRedisTemplate(@Qualifier(value="secondaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers, @Nonnull ObjectProvider<JacksonProperties> properties) {
            RedisTemplate template = JacksonRedisWraps.objectObjectRedisTemplate((RedisConnectionFactory)factory, (JacksonProperties)((JacksonProperties)properties.getIfAvailable()));
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, SecondaryRedisAutoConfiguration.OBJECT_REDIS_TEMPLATE));
            template.afterPropertiesSet();
            return template;
        }

        @Bean(name={"secondaryStringRedisTemplate"})
        @ConditionalOnBean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"secondaryStringRedisTemplate"})
        public StringRedisTemplate stringRedisTemplate(@Qualifier(value="secondaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<StringRedisTemplateCustomizer> customizers) {
            StringRedisTemplate template = new RedisAutoConfiguration().stringRedisTemplate(factory);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, SecondaryRedisAutoConfiguration.STRING_REDIS_TEMPLATE));
            template.afterPropertiesSet();
            return template;
        }

        @Bean(name={"secondarySessionRedisTemplate"})
        @ConditionalOnBean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"secondarySessionRedisTemplate"})
        @ConditionalOnMissingClass(value={"com.fasterxml.jackson.databind.ObjectMapper"})
        public RedisTemplate<String, Object> classicSessionRedisTemplate(@Qualifier(value="secondaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers) {
            RedisTemplate template = RedisConfigWraps.redisTemplate((RedisConnectionFactory)factory, (RedisSerializer)RedisSerializer.string(), (RedisSerializer)RedisSerializer.java());
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, SecondaryRedisAutoConfiguration.SESSION_REDIS_TEMPLATE));
            return template;
        }

        @Bean(name={"secondarySessionRedisTemplate"})
        @ConditionalOnBean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnClass(value={ObjectMapper.class})
        @ConditionalOnMissingBean(name={"secondarySessionRedisTemplate"})
        public RedisTemplate<String, Object> jasksonSessionRedisTemplate(@Qualifier(value="secondaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers, @Nonnull ObjectProvider<JacksonProperties> properties) {
            Jackson2JsonRedisSerializer valueSerializer = JacksonRedisWraps.jsonObjectSerializer((JacksonProperties)((JacksonProperties)properties.getIfAvailable()));
            RedisTemplate template = RedisConfigWraps.redisTemplate((RedisConnectionFactory)factory, (RedisSerializer)RedisSerializer.string(), (RedisSerializer)valueSerializer);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, SecondaryRedisAutoConfiguration.SESSION_REDIS_TEMPLATE));
            return template;
        }
    }

    @ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"client-type"}, havingValue="jedis", matchIfMissing=true)
    @ConditionalOnClass(value={ObjectPool.class, redis.clients.jedis.Jedis.class})
    @Order(value=2)
    static class Jedis {
        Jedis() {
        }

        @Bean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnBean(name={"secondaryRedisProperties"})
        @ConditionalOnMissingBean(name={"secondaryRedisConnectionFactory"}, value={RedisConnectionFactory.class})
        public JedisConnectionFactory redisConnectionFactory(@Qualifier(value="secondaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRedisConnectionDetails") @Nullable RedisConnectionDetails details, @Autowired(required=false) @Qualifier(value="secondaryRedisStandaloneConfiguration") @Nullable RedisStandaloneConfiguration standalone, @Autowired(required=false) @Qualifier(value="secondaryRedisSentinelConfiguration") @Nullable RedisSentinelConfiguration sentinel, @Autowired(required=false) @Qualifier(value="secondaryRedisClusterConfiguration") @Nullable RedisClusterConfiguration cluster, @Autowired(required=false) @Qualifier(value="secondaryRedisSslBundles") @Nullable SslBundles bundles, @Autowired(required=false) @Qualifier(value="secondaryJedisClientCustomizer") @Nullable JedisClientConfigurationBuilderCustomizer customizer) {
            return JedisConfigurationUtils.redisConnectionFactory(properties, details, standalone, sentinel, cluster, bundles, customizer);
        }
    }

    @ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"client-type"}, havingValue="lettuce", matchIfMissing=true)
    @ConditionalOnClass(value={RedisClient.class})
    @Order(value=1)
    static class Lettuce {
        Lettuce() {
        }

        @Bean(name={"secondaryLettuceClientResources"}, destroyMethod="shutdown")
        @ConditionalOnMissingBean(name={"secondaryLettuceClientResources"}, value={ClientResources.class})
        public DefaultClientResources lettuceClientResources() {
            return DefaultClientResources.create();
        }

        @Bean(name={"secondaryRedisConnectionFactory"})
        @ConditionalOnBean(name={"secondaryRedisProperties", "secondaryLettuceClientResources"})
        @ConditionalOnMissingBean(name={"secondaryRedisConnectionFactory"}, value={RedisConnectionFactory.class})
        public LettuceConnectionFactory redisConnectionFactory(@Qualifier(value="secondaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRedisConnectionDetails") @Nullable RedisConnectionDetails details, @Autowired(required=false) @Qualifier(value="secondaryRedisStandaloneConfiguration") @Nullable RedisStandaloneConfiguration standalone, @Autowired(required=false) @Qualifier(value="secondaryRedisSentinelConfiguration") @Nullable RedisSentinelConfiguration sentinel, @Autowired(required=false) @Qualifier(value="secondaryRedisClusterConfiguration") @Nullable RedisClusterConfiguration cluster, @Autowired(required=false) @Qualifier(value="secondaryRedisSslBundles") @Nullable SslBundles bundles, @Autowired(required=false) @Qualifier(value="secondaryLettuceClientConfigurationCustomizer") @Nullable LettuceClientConfigurationBuilderCustomizer configCustomizer, @Autowired(required=false) @Qualifier(value="secondaryLettuceClientOptionCustomizer") @Nullable LettuceClientOptionsBuilderCustomizer optionCustomizer, @Qualifier(value="secondaryLettuceClientResources") @Nonnull ClientResources resources) {
            return LettuceConfigurationUtils.redisConnectionFactory(properties, details, standalone, sentinel, cluster, bundles, configCustomizer, optionCustomizer, resources);
        }
    }

    @Order(value=0)
    static class Entry {
        Entry() {
        }

        @Bean(name={"secondaryRedisProperties"})
        @ConditionalOnMissingBean(name={"secondaryRedisProperties"})
        @ConfigurationProperties(prefix="spring.multiple-redis.secondary")
        public RedisProperties redisProperties() {
            return new RedisProperties();
        }

        @Bean(name={"secondaryRedisConnectionDetails"})
        @ConditionalOnBean(name={"secondaryRedisProperties"})
        @ConditionalOnMissingBean(name={"secondaryRedisConnectionDetails"})
        public RedisConnectionDetails redisConnectionDetails(@Qualifier(value="secondaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="secondaryRedisSslBundles") @Nullable SslBundles bundles) {
            return RedisConfigurationUtils.redisConnectionDetails(properties, bundles);
        }

        @Bean(name={"secondaryRedisStandaloneConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"standalone"}, matchIfMissing=true)
        @ConditionalOnBean(name={"secondaryRedisProperties"})
        @ConditionalOnMissingBean(name={"secondaryRedisStandaloneConfiguration"})
        public RedisStandaloneConfiguration redisStandaloneConfiguration(@Qualifier(value="secondaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisStandaloneConfiguration();
        }

        @Bean(name={"secondaryRedisSentinelConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"sentinel"})
        @ConditionalOnBean(name={"secondaryRedisProperties"})
        @ConditionalOnMissingBean(name={"secondaryRedisSentinelConfiguration"})
        public RedisSentinelConfiguration redisSentinelConfiguration(@Qualifier(value="secondaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisSentinelConfiguration();
        }

        @Bean(name={"secondaryRedisClusterConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.secondary", name={"cluster"})
        @ConditionalOnBean(name={"secondaryRedisProperties"})
        @ConditionalOnMissingBean(name={"secondaryRedisClusterConfiguration"})
        public RedisClusterConfiguration redisClusterConfiguration(@Qualifier(value="secondaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisClusterConfiguration();
        }
    }
}

