/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.commonplexus.springcondition.annotation.ConditionalOnAllBooleanProperties;
import cn.unikue.commonplexus.springutil.util.RedisConfigWraps;
import cn.unikue.springstarter.cacheexpiry.resolver.impl.RedisExpiryCacheResolver;
import cn.unikue.springstarter.multipleredis.config.PrimaryRedisCacheConfiguration;
import cn.unikue.springstarter.multipleredis.config.SecondaryRedisAutoConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAllBooleanProperties(value={@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true), @ConditionalOnBooleanProperty(prefix="spring.multiple-redis.secondary", name={"cache-enabled"}, matchIfMissing=true)})
@ConditionalOnProperty(prefix="spring.cache", name={"type"}, havingValue="redis", matchIfMissing=true)
@ConditionalOnBean(value={CacheAspectSupport.class, CacheProperties.class})
@ConditionalOnClass(value={CacheManager.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, PrimaryRedisCacheConfiguration.class, SecondaryRedisAutoConfiguration.class})
@AutoConfigureBefore(name={"cn.unikue.springstarter.cacheexpiry.config.RedisExpiryCacheConfiguration"})
public class SecondaryRedisCacheConfiguration {
    public static final String CACHE_MANAGER = "secondaryRedisCacheManager";
    public static final String CACHE_RESOLVER = "secondaryRedisCacheResolver";

    @Bean(name={"secondaryRedisCacheManager"})
    @ConditionalOnBean(name={"secondaryRedisConnectionFactory"})
    @ConditionalOnMissingBean(name={"secondaryRedisCacheManager"})
    public CacheManager cacheManager(@Qualifier(value="secondaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull CacheProperties cacheProperties, @Nullable JacksonProperties jacksonProperties) {
        return RedisConfigWraps.cacheManager((RedisConnectionFactory)factory, (CacheProperties)cacheProperties, (JacksonProperties)jacksonProperties);
    }

    @Bean(name={"secondaryRedisCacheResolver"})
    @ConditionalOnClass(value={RedisExpiryCacheResolver.class})
    @ConditionalOnBean(name={"secondaryRedisCacheManager"})
    @ConditionalOnMissingBean(name={"secondaryRedisCacheResolver"})
    public CacheResolver cacheResolver(@Qualifier(value="secondaryRedisCacheManager") @Nonnull CacheManager cacheManager) {
        return new RedisExpiryCacheResolver(cacheManager);
    }
}

