/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.commonplexus.springcondition.annotation.ConditionalOnAllBooleanProperties;
import cn.unikue.springstarter.multipleredis.config.PrimaryRedisSessionConfiguration;
import cn.unikue.springstarter.multipleredis.config.SecondaryRedisAutoConfiguration;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.RedisSessionRepository;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAllBooleanProperties(value={@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true), @ConditionalOnBooleanProperty(prefix="spring.multiple-redis.secondary", name={"session.enabled"}, matchIfMissing=true)})
@ConditionalOnProperty(prefix="spring.session", name={"store-type"}, havingValue="redis", matchIfMissing=true)
@ConditionalOnClass(value={RedisOperations.class, RedisSessionRepository.class})
@ConditionalOnBean(name={"secondaryObjectRedisTemplate"})
@AutoConfigureAfter(value={PrimaryRedisSessionConfiguration.class, SecondaryRedisAutoConfiguration.class})
public class SecondaryRedisSessionConfiguration {
    public static final String SESSION_REPOSITORY = "secondaryRedisIndexedSessionRepository";

    @Bean(name={"secondaryRedisIndexedSessionRepository"})
    @ConditionalOnMissingBean(name={"secondaryRedisIndexedSessionRepository"}, type={"org.springframework.session.SessionRepository"})
    public RedisIndexedSessionRepository sessionRepository(@Qualifier(value="secondarySessionRedisTemplate") @Nonnull RedisTemplate<String, Object> template) {
        return new RedisIndexedSessionRepository(template);
    }
}

