/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.config;

import cn.unikue.commonplexus.springcondition.annotation.ConditionalOnAnyProperties;
import cn.unikue.commonplexus.springutil.util.JacksonRedisWraps;
import cn.unikue.commonplexus.springutil.util.RedisConfigWraps;
import cn.unikue.springstarter.multipleredis.config.SecondaryRedisAutoConfiguration;
import cn.unikue.springstarter.multipleredis.facade.RedisTemplateCustomizer;
import cn.unikue.springstarter.multipleredis.facade.StringRedisTemplateCustomizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.pool2.ObjectPool;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.JedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientOptionsBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.SimpleRedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true)
@ConditionalOnAnyProperties(value={@ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"url"}), @ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"host"})})
@ConditionalOnClass(value={RedisOperations.class})
@AutoConfigureAfter(value={SecondaryRedisAutoConfiguration.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class})
@Import(value={Entry.class, Lettuce.class, Jedis.class, Stage.class})
public class TertiaryRedisAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.multiple-redis.tertiary";
    public static final String REDIS_PROPERTIES = "tertiaryRedisProperties";
    public static final String CONNECTION_DETAILS = "tertiaryRedisConnectionDetails";
    public static final String STANDALONE_CONFIGURATION = "tertiaryRedisStandaloneConfiguration";
    public static final String SENTINEL_CONFIGURATION = "tertiaryRedisSentinelConfiguration";
    public static final String CLUSTER_CONFIGURATION = "tertiaryRedisClusterConfiguration";
    public static final String SSL_BUNDLES = "tertiaryRedisSslBundles";
    public static final String LETTUCE_CLIENT_CONFIGURATION_CUSTOMIZER = "tertiaryLettuceClientConfigurationCustomizer";
    public static final String LETTUCE_CLIENT_OPTION_CUSTOMIZER = "tertiaryLettuceClientOptionCustomizer";
    public static final String LETTUCE_CLIENT_RESOURCES = "tertiaryLettuceClientResources";
    public static final String JEDIS_CLIENT_CUSTOMIZER = "tertiaryJedisClientCustomizer";
    public static final String CONNECTION_FACTORY = "tertiaryRedisConnectionFactory";
    public static final String OBJECT_REDIS_TEMPLATE = "tertiaryObjectRedisTemplate";
    public static final String SESSION_REDIS_TEMPLATE = "tertiarySessionRedisTemplate";
    public static final String STRING_REDIS_TEMPLATE = "tertiaryStringRedisTemplate";

    @Order(value=3)
    static class Stage {
        Stage() {
        }

        @Bean(name={"tertiaryObjectRedisTemplate"})
        @ConditionalOnBean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"tertiaryObjectRedisTemplate"})
        @ConditionalOnMissingClass(value={"com.fasterxml.jackson.databind.ObjectMapper"})
        public RedisTemplate<Object, Object> classicObjectRedisTemplate(@Qualifier(value="tertiaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers) {
            RedisTemplate template = new RedisAutoConfiguration().redisTemplate(factory);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, TertiaryRedisAutoConfiguration.OBJECT_REDIS_TEMPLATE));
            template.afterPropertiesSet();
            return template;
        }

        @Bean(name={"tertiaryObjectRedisTemplate"})
        @ConditionalOnBean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnClass(value={ObjectMapper.class})
        @ConditionalOnMissingBean(name={"tertiaryObjectRedisTemplate"})
        public RedisTemplate<Object, Object> jacksonObjectRedisTemplate(@Qualifier(value="tertiaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers, @Nonnull ObjectProvider<JacksonProperties> properties) {
            RedisTemplate template = JacksonRedisWraps.objectObjectRedisTemplate((RedisConnectionFactory)factory, (JacksonProperties)((JacksonProperties)properties.getIfAvailable()));
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, TertiaryRedisAutoConfiguration.OBJECT_REDIS_TEMPLATE));
            template.afterPropertiesSet();
            return template;
        }

        @Bean(name={"tertiaryStringRedisTemplate"})
        @ConditionalOnBean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"tertiaryStringRedisTemplate"})
        public StringRedisTemplate stringRedisTemplate(@Qualifier(value="tertiaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<StringRedisTemplateCustomizer> customizers) {
            StringRedisTemplate template = new RedisAutoConfiguration().stringRedisTemplate(factory);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, TertiaryRedisAutoConfiguration.STRING_REDIS_TEMPLATE));
            template.afterPropertiesSet();
            return template;
        }

        @Bean(name={"tertiarySessionRedisTemplate"})
        @ConditionalOnBean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnMissingBean(name={"tertiarySessionRedisTemplate"})
        @ConditionalOnMissingClass(value={"com.fasterxml.jackson.databind.ObjectMapper"})
        public RedisTemplate<String, Object> classicSessionRedisTemplate(@Qualifier(value="tertiaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers) {
            RedisTemplate template = RedisConfigWraps.redisTemplate((RedisConnectionFactory)factory, (RedisSerializer)RedisSerializer.string(), (RedisSerializer)RedisSerializer.java());
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, TertiaryRedisAutoConfiguration.SESSION_REDIS_TEMPLATE));
            return template;
        }

        @Bean(name={"tertiarySessionRedisTemplate"})
        @ConditionalOnBean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnClass(value={ObjectMapper.class})
        @ConditionalOnMissingBean(name={"tertiarySessionRedisTemplate"})
        public RedisTemplate<String, Object> jasksonSessionRedisTemplate(@Qualifier(value="tertiaryRedisConnectionFactory") @Nonnull RedisConnectionFactory factory, @Nonnull ObjectProvider<RedisTemplateCustomizer> customizers, @Nonnull ObjectProvider<JacksonProperties> properties) {
            Jackson2JsonRedisSerializer valueSerializer = JacksonRedisWraps.jsonObjectSerializer((JacksonProperties)((JacksonProperties)properties.getIfAvailable()));
            RedisTemplate template = RedisConfigWraps.redisTemplate((RedisConnectionFactory)factory, (RedisSerializer)RedisSerializer.string(), (RedisSerializer)valueSerializer);
            customizers.orderedStream().filter(Objects::nonNull).forEach(customizer -> customizer.customize(template, TertiaryRedisAutoConfiguration.SESSION_REDIS_TEMPLATE));
            return template;
        }
    }

    @ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"client-type"}, havingValue="jedis", matchIfMissing=true)
    @ConditionalOnClass(value={ObjectPool.class, redis.clients.jedis.Jedis.class})
    @Order(value=2)
    static class Jedis {
        Jedis() {
        }

        @Bean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnBean(name={"tertiaryRedisProperties"})
        @ConditionalOnMissingBean(name={"tertiaryRedisConnectionFactory"}, value={RedisConnectionFactory.class})
        public JedisConnectionFactory redisConnectionFactory(@Qualifier(value="tertiaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRedisConnectionDetails") @Nullable RedisConnectionDetails details, @Autowired(required=false) @Qualifier(value="tertiaryRedisStandaloneConfiguration") @Nullable RedisStandaloneConfiguration standalone, @Autowired(required=false) @Qualifier(value="tertiaryRedisSentinelConfiguration") @Nullable RedisSentinelConfiguration sentinel, @Autowired(required=false) @Qualifier(value="tertiaryRedisClusterConfiguration") @Nullable RedisClusterConfiguration cluster, @Autowired(required=false) @Qualifier(value="tertiaryRedisSslBundles") @Nullable SslBundles bundles, @Autowired(required=false) @Qualifier(value="tertiaryJedisClientCustomizer") @Nullable JedisClientConfigurationBuilderCustomizer customizer) {
            return JedisConfigurationUtils.redisConnectionFactory(properties, details, standalone, sentinel, cluster, bundles, customizer);
        }
    }

    @ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"client-type"}, havingValue="lettuce", matchIfMissing=true)
    @ConditionalOnClass(value={RedisClient.class})
    @Order(value=1)
    static class Lettuce {
        Lettuce() {
        }

        @Bean(name={"tertiaryLettuceClientResources"}, destroyMethod="shutdown")
        @ConditionalOnMissingBean(name={"tertiaryLettuceClientResources"}, value={ClientResources.class})
        public DefaultClientResources lettuceClientResources() {
            return DefaultClientResources.create();
        }

        @Bean(name={"tertiaryRedisConnectionFactory"})
        @ConditionalOnBean(name={"tertiaryRedisProperties", "tertiaryLettuceClientResources"})
        @ConditionalOnMissingBean(name={"tertiaryRedisConnectionFactory"}, value={RedisConnectionFactory.class})
        public LettuceConnectionFactory redisConnectionFactory(@Qualifier(value="tertiaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRedisConnectionDetails") @Nullable RedisConnectionDetails details, @Autowired(required=false) @Qualifier(value="tertiaryRedisStandaloneConfiguration") @Nullable RedisStandaloneConfiguration standalone, @Autowired(required=false) @Qualifier(value="tertiaryRedisSentinelConfiguration") @Nullable RedisSentinelConfiguration sentinel, @Autowired(required=false) @Qualifier(value="tertiaryRedisClusterConfiguration") @Nullable RedisClusterConfiguration cluster, @Autowired(required=false) @Qualifier(value="tertiaryRedisSslBundles") @Nullable SslBundles bundles, @Autowired(required=false) @Qualifier(value="tertiaryLettuceClientConfigurationCustomizer") @Nullable LettuceClientConfigurationBuilderCustomizer configCustomizer, @Autowired(required=false) @Qualifier(value="tertiaryLettuceClientOptionCustomizer") @Nullable LettuceClientOptionsBuilderCustomizer optionCustomizer, @Qualifier(value="tertiaryLettuceClientResources") @Nonnull ClientResources resources) {
            return LettuceConfigurationUtils.redisConnectionFactory(properties, details, standalone, sentinel, cluster, bundles, configCustomizer, optionCustomizer, resources);
        }
    }

    @Order(value=0)
    static class Entry {
        Entry() {
        }

        @Bean(name={"tertiaryRedisProperties"})
        @ConditionalOnMissingBean(name={"tertiaryRedisProperties"})
        @ConfigurationProperties(prefix="spring.multiple-redis.tertiary")
        public RedisProperties redisProperties() {
            return new RedisProperties();
        }

        @Bean(name={"tertiaryRedisConnectionDetails"})
        @ConditionalOnBean(name={"tertiaryRedisProperties"})
        @ConditionalOnMissingBean(name={"tertiaryRedisConnectionDetails"})
        public RedisConnectionDetails redisConnectionDetails(@Qualifier(value="tertiaryRedisProperties") @Nonnull RedisProperties properties, @Autowired(required=false) @Qualifier(value="tertiaryRedisSslBundles") @Nullable SslBundles bundles) {
            return RedisConfigurationUtils.redisConnectionDetails(properties, bundles);
        }

        @Bean(name={"tertiaryRedisStandaloneConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"standalone"}, matchIfMissing=true)
        @ConditionalOnBean(name={"tertiaryRedisProperties"})
        @ConditionalOnMissingBean(name={"tertiaryRedisStandaloneConfiguration"})
        public RedisStandaloneConfiguration redisStandaloneConfiguration(@Qualifier(value="tertiaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisStandaloneConfiguration();
        }

        @Bean(name={"tertiaryRedisSentinelConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"sentinel"})
        @ConditionalOnBean(name={"tertiaryRedisProperties"})
        @ConditionalOnMissingBean(name={"tertiaryRedisSentinelConfiguration"})
        public RedisSentinelConfiguration redisSentinelConfiguration(@Qualifier(value="tertiaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisSentinelConfiguration();
        }

        @Bean(name={"tertiaryRedisClusterConfiguration"})
        @ConditionalOnProperty(prefix="spring.multiple-redis.tertiary", name={"cluster"})
        @ConditionalOnBean(name={"tertiaryRedisProperties"})
        @ConditionalOnMissingBean(name={"tertiaryRedisClusterConfiguration"})
        public RedisClusterConfiguration redisClusterConfiguration(@Qualifier(value="tertiaryRedisProperties") @Nonnull RedisProperties properties) {
            return new SimpleRedisConnectionConfiguration(properties).getRedisClusterConfiguration();
        }
    }
}

