/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.multipleredis.registrar;

import cn.unikue.commonplexus.javaseutil.enumeration.NumberOrderType;
import cn.unikue.commonplexus.springutil.util.BeanFactoryWraps;
import cn.unikue.commonplexus.springutil.util.ReflectionUtilsWraps;
import cn.unikue.springstarter.multipleredis.annotation.EnableMultipleRedisHttpSession;
import cn.unikue.springstarter.multipleredis.config.PrimaryRedisAutoConfiguration;
import cn.unikue.springstarter.multipleredis.config.SecondaryRedisAutoConfiguration;
import cn.unikue.springstarter.multipleredis.config.TertiaryRedisAutoConfiguration;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.FlushMode;
import org.springframework.session.SaveMode;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisOperations;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.multiple-redis", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={RedisOperations.class, SpringSessionRedisOperations.class})
@AutoConfigureAfter(value={PrimaryRedisAutoConfiguration.class, SecondaryRedisAutoConfiguration.class, TertiaryRedisAutoConfiguration.class})
@AutoConfigureBefore(value={RedisHttpSessionConfiguration.class})
public class MultipleRedisHttpSessionRegistrar
extends RedisHttpSessionConfiguration
implements BeanFactoryAware {
    private NumberOrderType redisConnection;
    protected BeanFactory beanFactory;

    public void setImportMetadata(@Nonnull AnnotationMetadata metadata) {
        RedisConnectionFactory factory;
        StringValueResolver resolver;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EnableMultipleRedisHttpSession.class.getName()));
        if (ObjectUtils.isEmpty((Object)attributes)) {
            return;
        }
        this.redisConnection = (NumberOrderType)attributes.getEnum("redisConnection");
        super.setMaxInactiveInterval(Duration.ofSeconds((Long)attributes.getNumber("maxInactiveInterval")));
        String redisNamespace = attributes.getString("redisNamespace");
        if (StringUtils.hasText((String)redisNamespace) && (resolver = (StringValueResolver)ReflectionUtilsWraps.getFieldAs((Object)((Object)this), (String)"embeddedValueResolver", (boolean)true, StringValueResolver.class)) != null) {
            super.setRedisNamespace(resolver.resolveStringValue(redisNamespace));
        }
        super.setFlushMode((FlushMode)attributes.getEnum("flushMode"));
        super.setSaveMode((SaveMode)attributes.getEnum("saveMode"));
        if (this.redisConnection == null) {
            return;
        }
        switch (this.redisConnection) {
            case PRIMARY: {
                RedisConnectionFactory redisConnectionFactory = (RedisConnectionFactory)BeanFactoryWraps.getBean((BeanFactory)this.beanFactory, (String)"primaryRedisConnectionFactory", RedisConnectionFactory.class);
                break;
            }
            case SECONDARY: {
                RedisConnectionFactory redisConnectionFactory = (RedisConnectionFactory)BeanFactoryWraps.getBean((BeanFactory)this.beanFactory, (String)"secondaryRedisConnectionFactory", RedisConnectionFactory.class);
                break;
            }
            case TERTIARY: {
                RedisConnectionFactory redisConnectionFactory = (RedisConnectionFactory)BeanFactoryWraps.getBean((BeanFactory)this.beanFactory, (String)"tertiaryRedisConnectionFactory", RedisConnectionFactory.class);
                break;
            }
            default: {
                RedisConnectionFactory redisConnectionFactory = factory = null;
            }
        }
        if (factory != null) {
            ReflectionUtilsWraps.setField((Object)this.redisConnection, (String)"redisConnectionFactory", (boolean)true, (Object)((Object)this));
        }
    }

    @Generated
    public NumberOrderType getRedisConnection() {
        return this.redisConnection;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

