/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import cn.unikue.commonplexus.springutil.support.SingletonObjectProvider;
import io.lettuce.core.resource.ClientResources;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientOptionsBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisConfigurationUtils;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

public abstract class LettuceConfigurationUtils {
    public static LettuceConnectionFactory redisConnectionFactory(@Nonnull RedisProperties properties, @Nullable RedisConnectionDetails details, @Nullable RedisStandaloneConfiguration standalone, @Nullable RedisSentinelConfiguration sentinel, @Nullable RedisClusterConfiguration cluster, @Nullable SslBundles bundles, @Nullable LettuceClientConfigurationBuilderCustomizer configCustomizer, @Nullable LettuceClientOptionsBuilderCustomizer optionCustomizer, @Nonnull ClientResources resources) {
        RedisConnectionDetails alias = (RedisConnectionDetails)ObjectUtils.defaultIfNull((Object)details, (Object)RedisConfigurationUtils.redisConnectionDetails(properties, bundles));
        LettuceConnectionConfiguration configuration = new LettuceConnectionConfiguration(properties, (ObjectProvider)SingletonObjectProvider.ofNullable((Object)standalone), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)sentinel), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)cluster), alias);
        return configuration.redisConnectionFactory((ObjectProvider)SingletonObjectProvider.ofNullable((Object)configCustomizer), (ObjectProvider)SingletonObjectProvider.ofNullable((Object)optionCustomizer), resources);
    }
}

