/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.ratelimiter.aspect;

import cn.unikue.commonplexus.javaseutil.util.StringUtilsWraps;
import cn.unikue.commonplexus.springutil.util.AopUtilsWraps;
import cn.unikue.commonplexus.springutil.util.BeanFactoryWraps;
import cn.unikue.commonplexus.springutil.util.RequestMappingWraps;
import cn.unikue.commonplexus.springutil.util.WebUtilsWraps;
import cn.unikue.springstarter.ratelimiter.annotation.RateLimit;
import cn.unikue.springstarter.ratelimiter.enumeration.LimiterTriggerType;
import cn.unikue.springstarter.ratelimiter.facade.RateLimitCallback;
import cn.unikue.springstarter.ratelimiter.facade.RateLimitInformant;
import cn.unikue.springstarter.ratelimiter.property.RateLimiterProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractRateLimitAspect
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRateLimitAspect.class);
    protected final RateLimiterProperties limiterProperties;
    protected RateLimitCallback limitCallback;
    protected ApplicationContext applicationContext;

    public AbstractRateLimitAspect(@Nonnull RateLimiterProperties properties, @Nullable RateLimitCallback callback) {
        this.limiterProperties = properties;
        this.limitCallback = callback;
    }

    @Around(value="@annotation(cn.unikue.springstarter.ratelimiter.annotation.RateLimit)")
    public Object aroundPoint(@Nonnull ProceedingJoinPoint point) throws Throwable {
        String identifier;
        Method method = AopUtilsWraps.getTargetMethod((JoinPoint)point);
        Assert.notNull((Object)method, (String)"Assertion failed! This argument must not be null.");
        RateLimit annotation = (RateLimit)AnnotationUtils.getAnnotation((Method)method, RateLimit.class);
        if (annotation == null || annotation.ttl() <= 0L || annotation.unit() == null) {
            return point.proceed();
        }
        if (!RequestMappingWraps.anyMapping((Method)method) && log.isWarnEnabled()) {
            log.warn("Method '{}.{}' annotated with '@{}' should also annotated with '@RequestMapping/@GetMapping/@PostMapping/@PatchMapping/@PutMapping/@DeleteMapping' as well", new Object[]{method.getDeclaringClass().getCanonicalName(), RateLimit.class.getSimpleName(), method.getName()});
        }
        if (StringUtils.isBlank((CharSequence)(identifier = this.determineIdentifier(method, annotation)))) {
            return point.proceed();
        }
        return this.processPoint(point, identifier, annotation);
    }

    @Nullable
    protected String determineIdentifier(@Nonnull Method method, @Nonnull RateLimit annotation) throws Exception {
        String name = StringUtils.join((Object[])new String[]{this.limiterProperties.getNamePrefix(), ClassUtils.getQualifiedMethodName((Method)method), this.limiterProperties.getNameSuffix()});
        StringBuilder builder = new StringBuilder(annotation.triggerType().getValue());
        builder.append('[');
        if (annotation.triggerType() == LimiterTriggerType.IP_ADDRESS || annotation.triggerType() == LimiterTriggerType.SESSION) {
            HttpServletRequest request = WebUtilsWraps.getContextServletRequest();
            if (request == null) {
                return null;
            }
            if (annotation.triggerType() == LimiterTriggerType.IP_ADDRESS) {
                builder.append(WebUtilsWraps.getRemoteAddress((HttpServletRequest)request));
            } else if (annotation.triggerType() == LimiterTriggerType.SESSION) {
                builder.append(WebUtilsWraps.getSessionId((HttpServletRequest)request));
            }
        } else if (annotation.triggerType() == LimiterTriggerType.USERNAME) {
            RateLimitInformant informant = (RateLimitInformant)BeanFactoryWraps.getBean((BeanFactory)this.applicationContext, RateLimitInformant.class);
            if (informant == null) {
                throw new NoSuchBeanDefinitionException(RateLimitInformant.class);
            }
            builder.append(informant.getUsername());
        }
        builder.append(']');
        return StringUtilsWraps.joinWithColon((Object[])new String[]{name, builder.toString()});
    }

    protected abstract Object processPoint(@Nonnull ProceedingJoinPoint var1, @Nonnull String var2, @Nonnull RateLimit var3) throws Throwable;

    @Generated
    public AbstractRateLimitAspect(RateLimiterProperties limiterProperties) {
        this.limiterProperties = limiterProperties;
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

