/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.ratelimiter.aspect;

import cn.unikue.commonplexus.javaseutil.util.LocalDateWraps;
import cn.unikue.commonplexus.springutil.util.RedisTemplateWraps;
import cn.unikue.commonplexus.springutil.util.WebUtilsWraps;
import cn.unikue.springstarter.ratelimiter.annotation.RateLimit;
import cn.unikue.springstarter.ratelimiter.aspect.AbstractRateLimitAspect;
import cn.unikue.springstarter.ratelimiter.event.RateLimitedEvent;
import cn.unikue.springstarter.ratelimiter.exception.RateLimitedException;
import cn.unikue.springstarter.ratelimiter.facade.RateLimitCallback;
import cn.unikue.springstarter.ratelimiter.property.RateLimiterProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

@Aspect
public class RedisRateLimitAspect
extends AbstractRateLimitAspect {
    private StringRedisTemplate redisTemplate;

    public RedisRateLimitAspect(RateLimiterProperties limitProperties) {
        super(limitProperties);
    }

    public RedisRateLimitAspect(@Nonnull RateLimiterProperties properties, @Nullable RateLimitCallback callback, @Nonnull StringRedisTemplate template) {
        super(properties, callback);
        this.redisTemplate = template;
    }

    @Override
    protected Object processPoint(@Nonnull ProceedingJoinPoint point, @Nonnull String identifier, @Nonnull RateLimit annotation) throws Throwable {
        Assert.notNull((Object)this.redisTemplate, (String)"Assertion failed! This argument must not be null.");
        if (RedisTemplateWraps.existsKey((RedisTemplate)this.redisTemplate, (Object)identifier)) {
            HttpServletRequest request = WebUtilsWraps.getContextServletRequest();
            if (request != null) {
                this.applicationContext.publishEvent((ApplicationEvent)new RateLimitedEvent(request));
            }
            if (BooleanUtils.isTrue((Boolean)this.limiterProperties.getThrowException())) {
                throw new RateLimitedException();
            }
            Assert.notNull((Object)this.limitCallback, (String)"Assertion failed! This argument must not be null.");
            return this.limitCallback.process(point, annotation);
        }
        String dateTime = LocalDateWraps.formatCurrentDateTime();
        Object result = point.proceed();
        if (annotation.ttl() <= 0L || annotation.unit() == ChronoUnit.FOREVER) {
            this.redisTemplate.boundValueOps((Object)identifier).set((Object)dateTime);
        } else {
            this.redisTemplate.boundValueOps((Object)identifier).set((Object)dateTime, annotation.unit().getDuration().multipliedBy(annotation.ttl()));
        }
        return result;
    }

    @Generated
    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Generated
    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

