/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.ratelimiter.config;

import cn.unikue.springstarter.ratelimiter.aspect.RedisRateLimitAspect;
import cn.unikue.springstarter.ratelimiter.facade.RateLimitCallback;
import cn.unikue.springstarter.ratelimiter.facade.impl.DefaultRateLimitCallback;
import cn.unikue.springstarter.ratelimiter.property.RateLimiterProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBooleanProperty(prefix="spring.rate-limiter", name={"enabled"}, matchIfMissing=true)
@Import(value={Entry.class, Redis.class})
public class RateLimiterAutoConfiguration {
    public static final String PROPERTIES_PREFIX = "spring.rate-limiter";
    public static final String REDIS_TEMPLATE = "rateLimiterRedisTemplate";

    @Order(value=1)
    @ConditionalOnProperty(prefix="spring.rate-limiter", name={"storage-type"}, havingValue="redis", matchIfMissing=true)
    @ConditionalOnClass(name={"org.springframework.data.redis.core.RedisOperations"})
    static class Redis {
        Redis() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RedisRateLimitAspect redisRateLimitAspect(@Nonnull RateLimiterProperties properties, @Nonnull ObjectProvider<RateLimitCallback> callback, @Nullable @Qualifier(value="rateLimiterRedisTemplate") StringRedisTemplate preferredTemplate, @Nonnull ObjectProvider<StringRedisTemplate> presentTemplate) {
            return new RedisRateLimitAspect(properties, (RateLimitCallback)callback.getIfAvailable(), (StringRedisTemplate)ObjectUtils.defaultIfNull((Object)preferredTemplate, (Object)((StringRedisTemplate)presentTemplate.getIfAvailable())));
        }
    }

    @Order(value=0)
    @EnableConfigurationProperties(value={RateLimiterProperties.class})
    static class Entry {
        Entry() {
        }

        @Bean
        @ConditionalOnBooleanProperty(prefix="spring.rate-limiter", name={"throw-exception"}, havingValue=false, matchIfMissing=true)
        @ConditionalOnMissingBean
        public RateLimitCallback defaultRateLimitCallback(@Nonnull RateLimiterProperties properties) {
            return new DefaultRateLimitCallback(properties);
        }
    }
}

