/*
 * Decompiled with CFR 0.152.
 */
package cn.unikue.springstarter.ratelimiter.facade.impl;

import cn.unikue.commonplexus.springutil.structure.RestResponseStruct;
import cn.unikue.commonplexus.springutil.util.WebUtilsWraps;
import cn.unikue.springstarter.ratelimiter.annotation.RateLimit;
import cn.unikue.springstarter.ratelimiter.facade.impl.AbstractRateLimitCallback;
import cn.unikue.springstarter.ratelimiter.property.RateLimiterProperties;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class DefaultRateLimitCallback
extends AbstractRateLimitCallback {
    public DefaultRateLimitCallback(RateLimiterProperties properties) {
        super(properties);
    }

    @Override
    public Object process(@Nonnull ProceedingJoinPoint point, @Nonnull RateLimit annotation) throws Exception {
        HttpServletRequest request = WebUtilsWraps.getContextServletRequest();
        Assert.notNull((Object)request, (String)"Assertion failed! This argument must not be null.");
        return WebUtilsWraps.isRestRequest((HttpServletRequest)request) ? this.processRest(point, annotation) : this.processHtml(point, annotation);
    }

    protected Object processHtml(@Nonnull ProceedingJoinPoint point, @Nonnull RateLimit annotation) throws Exception {
        HttpServletRequest request = WebUtilsWraps.getContextServletRequest();
        HttpServletResponse response = WebUtilsWraps.getContextServletResponse();
        Assert.notNull((Object)request, (String)"Assertion failed! This argument must not be null.");
        Assert.notNull((Object)response, (String)"Assertion failed! This argument must not be null.");
        if (StringUtils.isNotBlank((CharSequence)this.limitProperties.getDeniedHtmlUrl())) {
            WebUtilsWraps.forwardRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)this.limitProperties.getDeniedHtmlUrl());
            return null;
        }
        WebUtilsWraps.writeResponse((HttpServletResponse)response, (String)super.resolveMessage(annotation));
        return null;
    }

    protected Object processRest(@Nonnull ProceedingJoinPoint point, @Nonnull RateLimit annotation) throws Exception {
        HttpServletRequest request = WebUtilsWraps.getContextServletRequest();
        HttpServletResponse response = WebUtilsWraps.getContextServletResponse();
        Assert.notNull((Object)request, (String)"Assertion failed! This argument must not be null.");
        Assert.notNull((Object)response, (String)"Assertion failed! This argument must not be null.");
        if (StringUtils.isNotBlank((CharSequence)this.limitProperties.getDeniedRestUrl())) {
            WebUtilsWraps.forwardRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)this.limitProperties.getDeniedRestUrl());
            return null;
        }
        return new RestResponseStruct(HttpStatus.FORBIDDEN, (Object)super.resolveMessage(annotation));
    }
}

