/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.To;
import io.vertx.up.atom.Envelop;
import io.vertx.up.log.Annal;
import io.zero.epic.fn.Fn;
import io.zero.epic.fn.wait.Case;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

class Async {
    private static final Annal LOGGER = Annal.get(Async.class);

    Async() {
    }

    static <T> Future<Envelop> toSingle(String pojo, CompletableFuture<T> completableFuture) {
        Future future = Future.future();
        Future<JsonObject> jsonFuture = Async.toJsonFuture(pojo, completableFuture);
        jsonFuture.setHandler(item -> future.complete((Object)To.toEnvelop(item.result())));
        return future;
    }

    static <T> Future<Envelop> toUnique(String pojo, CompletableFuture<List<T>> completableFuture) {
        Future future = Future.future();
        Future<JsonArray> arrayFuture = Async.toArrayFuture(pojo, completableFuture);
        arrayFuture.setHandler(item -> future.complete((Object)To.toEnvelop(To.toUnique((JsonArray)item.result(), pojo))));
        return future;
    }

    static <T> Future<Envelop> toMulti(String pojo, CompletableFuture<List<T>> completableFuture) {
        Future future = Future.future();
        Future<JsonArray> arrayFuture = Async.toArrayFuture(pojo, completableFuture);
        arrayFuture.setHandler(item -> future.complete((Object)To.toEnvelop(item.result())));
        return future;
    }

    static <T> Future<T> toFuture(CompletableFuture<T> completableFuture) {
        Future future = Future.future();
        ((CompletableFuture)completableFuture.thenAcceptAsync(arg_0 -> ((Future)future).complete(arg_0))).exceptionally(ex -> {
            LOGGER.jvm(ex);
            future.fail(ex);
            return null;
        });
        return future;
    }

    static <T> Future<JsonObject> toJsonFuture(String pojo, CompletableFuture<T> completableFuture) {
        Future future = Future.future();
        Fn.safeSemi((null == completableFuture ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonObject()), () -> ((CompletableFuture)completableFuture.thenAcceptAsync(item -> Fn.safeSemi((null == item ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonObject()), () -> future.complete((Object)To.toJson(item, pojo))))).exceptionally(ex -> {
            LOGGER.jvm(ex);
            future.fail(ex);
            return null;
        }));
        return future;
    }

    static <T> Future<JsonArray> toArrayFuture(String pojo, CompletableFuture<List<T>> completableFuture) {
        Future future = Future.future();
        Fn.safeSemi((null == completableFuture ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonArray()), () -> ((CompletableFuture)completableFuture.thenAcceptAsync(item -> Fn.safeSemi((null == item ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonArray()), () -> future.complete((Object)To.toArray(item, pojo))))).exceptionally(ex -> {
            LOGGER.jvm(ex);
            future.fail(ex);
            return null;
        }));
        return future;
    }

    static <T> Future<JsonObject> toUpsertFuture(T entity, String pojo, Supplier<Future<JsonObject>> supplier, Function<JsonObject, JsonObject> updateFun) {
        return Fn.match((Case.DefaultCase)Fn.fork(() -> Future.succeededFuture((Object)To.toJson(entity, pojo)).compose(item -> null == updateFun ? Future.succeededFuture((Object)item) : Future.succeededFuture(updateFun.apply((JsonObject)item)))), (Case[])new Case[]{Fn.branch((null == entity ? 1 : 0) != 0, supplier)});
    }
}

