/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.To;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception._500InternalServerException;
import io.zero.epic.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

class Fluctuate {
    Fluctuate() {
    }

    static <F, S, T> Future<List<T>> thenParallel(Future<List<F>> source, Function<F, Future<S>> generateFun, BiFunction<F, S, T> mergeFun) {
        return source.compose(first -> {
            ArrayList secondFutures = new ArrayList();
            Observable.fromIterable((Iterable)first).map(generateFun::apply).filter(Objects::nonNull).subscribe(secondFutures::add);
            Future result = Future.future();
            CompositeFuture.all(secondFutures).setHandler(res -> {
                List secondary = ((CompositeFuture)res.result()).list();
                List completed = Ut.zipperList((List)first, (List)secondary, (BiFunction)mergeFun);
                result.complete((Object)completed);
            });
            return result;
        });
    }

    static Future<JsonArray> thenScatterJson(Future<JsonArray> source, Function<JsonObject, Future<JsonArray>> generateFun, BiFunction<JsonObject, JsonArray, JsonObject> mergeFun) {
        return source.compose(first -> {
            ArrayList secondFutures = new ArrayList();
            Observable.fromIterable((Iterable)first).map(item -> (JsonObject)item).map(generateFun::apply).subscribe(secondFutures::add);
            Future result = Future.future();
            CompositeFuture.all(secondFutures).setHandler(res -> {
                List secondary = ((CompositeFuture)res.result()).list();
                List completed = Ut.zipperList((List)first.getList(), (List)secondary, (BiFunction)mergeFun);
                result.complete((Object)new JsonArray(completed));
            });
            return result;
        });
    }

    static Future<JsonArray> thenParallelArray(Future<JsonArray> source, Function<JsonObject, Future<JsonObject>> generateFun, BinaryOperator<JsonObject> operatorFun) {
        return source.compose(first -> {
            ArrayList secondFutures = new ArrayList();
            Observable.fromIterable((Iterable)first).map(item -> (JsonObject)item).map(generateFun::apply).subscribe(secondFutures::add);
            Future result = Future.future();
            CompositeFuture.all(secondFutures).setHandler(res -> {
                List secondary = ((CompositeFuture)res.result()).list();
                List completed = Ut.zipperList((List)first.getList(), (List)secondary, (BiFunction)operatorFun);
                result.complete((Object)new JsonArray(completed));
            });
            return result;
        });
    }

    static Future<JsonObject> thenParallelArray(Future<JsonArray> ... futures) {
        Future result = Future.future();
        CompositeFuture.all(Arrays.asList(futures)).setHandler(res -> {
            JsonObject resultMap = new JsonObject();
            Ut.itList((List)((CompositeFuture)res.result()).list(), (item, index) -> resultMap.put(index.toString(), item));
            result.complete((Object)resultMap);
        });
        return result;
    }

    static Future<JsonObject> thenParallelJson(Future<JsonObject> ... futures) {
        Future result = Future.future();
        CompositeFuture.all(Arrays.asList(futures)).setHandler(Fluctuate.thenResponse(result, finished -> {
            JsonObject resultMap = new JsonObject();
            if (null != finished) {
                Ut.itList((List)finished.list(), (item, index) -> resultMap.put(index.toString(), item));
            }
            return resultMap;
        }));
        return result;
    }

    static Future<JsonObject> thenParallelJson(Future<JsonObject> source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return source.compose(first -> {
            List secondFutures = (List)generateFun.apply((JsonObject)first);
            Future result = Future.future();
            CompositeFuture.all((List)secondFutures).setHandler(Fluctuate.thenResponse(result, finished -> {
                if (null != finished) {
                    List secondary = finished.list();
                    Ut.itList((List)secondary, (item, index) -> operatorFun[index].accept(first, item));
                }
                return first;
            }));
            return result;
        });
    }

    static <F, S, T> Future<T> thenComposite(Future<F> source, BiFunction<F, List<S>, T> mergeFun, Supplier<Future<S>> ... suppliers) {
        return source.compose(first -> {
            ArrayList<Future> secondFutures = new ArrayList<Future>();
            Observable.fromArray((Object[])suppliers).map(Supplier::get).subscribe(secondFutures::add);
            return Fluctuate.thenResponse(secondFutures, first, mergeFun);
        });
    }

    static Future<JsonArray> thenComposite(List<Future<JsonObject>> futures) {
        Future result = Future.future();
        ArrayList<Future<JsonObject>> converted = new ArrayList<Future<JsonObject>>(futures);
        CompositeFuture.all(converted).setHandler(Fluctuate.thenResponse(result, finished -> null == finished ? new JsonArray() : new JsonArray(finished.list())));
        return result;
    }

    static <F, S, T> Future<T> thenComposite(Future<F> source, BiFunction<F, List<S>, T> mergeFun, Function<F, Future<S>> ... functions) {
        return source.compose(first -> {
            ArrayList<Future> secondFutures = new ArrayList<Future>();
            Observable.fromArray((Object[])functions).map(item -> (Future)item.apply(first)).subscribe(secondFutures::add);
            return Fluctuate.thenResponse(secondFutures, first, mergeFun);
        });
    }

    static <T, F, R> Future<R> thenOtherwise(Future<Boolean> conditionFuture, Supplier<Future<T>> supplierTrue, Function<T, R> trueFun, Supplier<Future<F>> supplierFalse, Function<F, R> falseFun) {
        Future future = Future.future();
        conditionFuture.setHandler(handler -> {
            if (handler.succeeded() && ((Boolean)handler.result()).booleanValue()) {
                Future trueFuture = (Future)supplierTrue.get();
                trueFuture.setHandler(trueRes -> future.complete(trueFun.apply(trueRes.result())));
            } else {
                Future falseFuture = (Future)supplierFalse.get();
                falseFuture.setHandler(falseRes -> future.complete(falseFun.apply(falseRes.result())));
            }
        });
        return future;
    }

    static <T, R> Future<R> thenOtherwise(Future<Boolean> conditionFuture, Supplier<Future<T>> supplierTrue, Function<T, R> trueFun, Class<? extends WebException> clazz, Object ... args) {
        Future future = Future.future();
        conditionFuture.setHandler(handler -> {
            if (handler.succeeded() && ((Boolean)handler.result()).booleanValue()) {
                Future trueFuture = (Future)supplierTrue.get();
                trueFuture.setHandler(trueRes -> future.complete(trueFun.apply(trueRes.result())));
            } else if (null == clazz) {
                future.complete();
            } else {
                WebException error = (WebException)Ut.instance((Class)clazz, (Object[])args);
                future.fail((Throwable)error);
            }
        });
        return future;
    }

    static <T> Future<T> thenError(Class<? extends WebException> clazz, Object ... args) {
        WebException error = To.toError(clazz, args);
        return Future.failedFuture((Throwable)error);
    }

    private static <F, S, T> Future<T> thenResponse(List<Future> secondFutures, F first, BiFunction<F, List<S>, T> mergeFun) {
        Future result = Future.future();
        CompositeFuture.all(secondFutures).setHandler(Fluctuate.thenResponse(result, finished -> null == finished ? null : mergeFun.apply(first, finished.list())));
        return result;
    }

    static <T, I> Future<Set<T>> thenSet(List<I> data, Function<I, Future<T>> fun) {
        Future results = Future.future();
        ArrayList futures = new ArrayList();
        data.stream().map(fun).forEach(futures::add);
        CompositeFuture.all(futures).setHandler(Fluctuate.thenResponse(results, finished -> {
            if (null == finished) {
                return new HashSet();
            }
            List extracted = finished.list();
            return new HashSet(extracted);
        }));
        return results;
    }

    private static <T> Handler<AsyncResult<CompositeFuture>> thenResponse(Future<T> future, Function<CompositeFuture, T> fun) {
        return res -> {
            if (res.succeeded()) {
                Object callback = fun.apply((CompositeFuture)res.result());
                future.complete(callback);
            } else if (null != res.cause()) {
                res.cause().printStackTrace();
                future.fail(res.cause());
            } else {
                future.fail((Throwable)((Object)new _500InternalServerException(Fluctuate.class, null)));
            }
        };
    }
}

