/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.aiki.Async;
import io.vertx.up.aiki.JooqCond;
import io.vertx.up.aiki.Uarr;
import io.vertx.up.aiki.Ux;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.log.Annal;
import io.vertx.zero.atom.Mirror;
import io.vertx.zero.atom.Mojo;
import io.vertx.zero.exception.JooqFieldMissingException;
import io.vertx.zero.exception.JooqMergeException;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Operator;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWhereStep;
import org.jooq.SelectWithTiesAfterOffsetStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;

class JooqAnalyzer {
    private static final Annal LOGGER = Annal.get(JooqAnalyzer.class);
    private static final ConcurrentMap<Integer, VertxDAO> DAO_POOL = new ConcurrentHashMap<Integer, VertxDAO>();
    private final transient VertxDAO vertxDAO;
    private final transient ConcurrentMap<String, String> mapping = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, String> revert = new ConcurrentHashMap<String, String>();
    private transient Mojo pojo;
    private transient String pojoFile;

    private JooqAnalyzer(VertxDAO vertxDAO) {
        this.vertxDAO = (VertxDAO)Fn.pool(DAO_POOL, (Object)vertxDAO.hashCode(), () -> vertxDAO);
        this.initMapping();
    }

    static JooqAnalyzer create(VertxDAO vertxDAO) {
        return new JooqAnalyzer(vertxDAO);
    }

    private void initMapping() {
        Table tableField = (Table)Ut.field((Object)this.vertxDAO, (String)"table");
        Class typeCls = (Class)Ut.field((Object)this.vertxDAO, (String)"type");
        java.lang.reflect.Field[] fields = Ut.fields((Class)typeCls);
        Field[] columns = tableField.fields();
        for (int idx = 0; idx < columns.length; ++idx) {
            Field column = columns[idx];
            java.lang.reflect.Field field = fields[idx];
            this.mapping.put(field.getName(), column.getName());
            this.revert.put(column.getName(), field.getName());
        }
    }

    void bind(String pojo, Class<?> clazz) {
        if (Ut.isNil((String)pojo)) {
            this.pojoFile = null;
            this.pojo = null;
        } else {
            LOGGER.debug("[ ZERO ] ( Pojo Bind ) Pojo up.god.file = {0} has been bind to dao {1}, Field mode enabled.", new Object[]{pojo, clazz});
            this.pojoFile = pojo;
            this.pojo = Mirror.create(UxJooq.class).mount(pojo).mojo().put(this.mapping);
            LOGGER.debug("[ ZERO ] ( Pojo ) The analyzed result should be : Revert {0}, Columns = {1}", new Object[]{this.pojo.getRevert(), this.pojo.getColumns()});
        }
    }

    Field getColumn(String field) {
        String targetField;
        if (null == this.pojo) {
            targetField = this.mapping.values().contains(field) ? field : (String)this.mapping.get(field);
        } else if (this.pojo.getColumns().containsValue(field)) {
            targetField = field;
        } else {
            targetField = (String)this.pojo.getRevert().get(field);
            if (null == targetField) {
                targetField = field;
            }
            targetField = (String)this.mapping.get(targetField);
        }
        Fn.outUp((null == targetField ? 1 : 0) != 0, (Annal)LOGGER, JooqFieldMissingException.class, (Object[])new Object[]{UxJooq.class, field, Ut.field((Object)this.vertxDAO, (String)"type")});
        LOGGER.debug("[ ZERO ] ( Pojo ) The field \"{0}\" has been hitted ( converted ) to \"{1}\"", new Object[]{field, targetField});
        return DSL.field((String)targetField);
    }

    private <T> T skipPrimaryKey(T entity) {
        Table tableField = (Table)Ut.field((Object)this.vertxDAO, (String)"table");
        UniqueKey key = tableField.getPrimaryKey();
        key.getFields().stream().map(item -> ((TableField)item).getName()).filter(this.revert::containsKey).map(this.revert::get).forEach(item -> Ut.field((Object)entity, (String)item.toString(), null));
        return entity;
    }

    <T> T copyEntity(T target, T updated) {
        Fn.outUp((null == updated ? 1 : 0) != 0, (Annal)LOGGER, JooqMergeException.class, (Object[])new Object[]{UxJooq.class, null == target ? null : target.getClass(), Ut.serialize(target)});
        return (T)Fn.getSemi((null == target && null == updated ? 1 : 0) != 0, (Annal)LOGGER, () -> null, () -> {
            JsonObject targetJson = null == target ? new JsonObject() : (JsonObject)Ut.serializeJson((Object)target);
            JsonObject sourceJson = (JsonObject)Ut.serializeJson((Object)this.skipPrimaryKey(updated));
            targetJson.mergeIn(sourceJson, true);
            Class<?> type = null == target ? updated.getClass() : target.getClass();
            return Ut.deserialize((JsonObject)targetJson, type);
        });
    }

    String getPojoFile() {
        return this.pojoFile;
    }

    <T> Future<Integer> countAsync(Inquiry inquiry, Operator operator) {
        return this.countAsync(null == inquiry.getCriteria() ? new JsonObject() : inquiry.getCriteria().toJson(), operator);
    }

    <T> Future<Integer> countAsync(JsonObject filters, Operator operator) {
        Function<DSLContext, Integer> function = dslContext -> null == filters ? dslContext.fetchCount(this.vertxDAO.getTable()) : dslContext.fetchCount(this.vertxDAO.getTable(), JooqCond.transform(filters, operator, this::getColumn));
        return Async.toFuture(this.vertxDAO.executeAsync(function));
    }

    <T> Integer count(Inquiry inquiry, Operator operator) {
        return this.count(null == inquiry.getCriteria() ? new JsonObject() : inquiry.getCriteria().toJson(), operator);
    }

    <T> Integer count(JsonObject filters, Operator operator) {
        DSLContext context = JooqInfix.getDSL();
        return null == filters ? context.fetchCount(this.vertxDAO.getTable()) : context.fetchCount(this.vertxDAO.getTable(), JooqCond.transform(filters, operator, this::getColumn));
    }

    <T> Future<List<T>> searchAsync(JsonObject criteria) {
        Function<DSLContext, List> function = context -> this.searchInternal((DSLContext)context, criteria);
        return Async.toFuture(this.vertxDAO.executeAsync(function));
    }

    <T> List<T> search(JsonObject criteria) {
        DSLContext context = JooqInfix.getDSL();
        return this.searchInternal(context, criteria);
    }

    <T> Future<List<T>> searchAsync(Inquiry inquiry, Operator operator) {
        Function<DSLContext, List> function = context -> this.searchInternal((DSLContext)context, inquiry, operator);
        return Async.toFuture(this.vertxDAO.executeAsync(function));
    }

    <T> List<T> search(Inquiry inquiry, Operator operator) {
        DSLContext context = JooqInfix.getDSL();
        return this.searchInternal(context, inquiry, operator);
    }

    Future<JsonArray> searchJArrayAsync(Inquiry inquiry, Operator operator) {
        return this.searchAsync(inquiry, operator).compose(list -> {
            if (null == inquiry.getProjection()) {
                return Ux.thenJsonMore(list);
            }
            return Ux.thenJsonMore(list).compose(array -> Uarr.create((JsonArray)array).remove(inquiry.getProjection().toArray(new String[0])).toFuture());
        });
    }

    Future<JsonObject> searchJObjectAsync(Inquiry inquiry, String pojo, Operator operator) {
        JsonObject response = new JsonObject();
        return this.searchAsync(inquiry, operator).compose(list -> Ux.thenJsonMore(list, pojo)).compose(array -> {
            response.put("list", array);
            return this.countAsync(inquiry, operator);
        }).compose(counter -> {
            response.put("count", counter);
            return Future.succeededFuture((Object)response);
        });
    }

    Future<JsonObject> searchJObjectAsync(Inquiry inquiry, String pojo) {
        return this.searchJObjectAsync(inquiry, pojo, null);
    }

    <T> JsonObject searchJObject(Inquiry inquiry, String pojo, Operator operator) {
        JsonObject response = new JsonObject();
        List<T> list = this.search(inquiry, operator);
        response.put("list", Ux.thenJsonMore(list, pojo));
        Integer counter = this.count(inquiry, operator);
        response.put("count", counter);
        return response;
    }

    <T> JsonObject searchJObject(Inquiry inquiry, String pojo) {
        return this.searchJObject(inquiry, pojo, null);
    }

    <T> JsonArray searchJArray(Inquiry inquiry, Operator operator) {
        List<T> list = this.search(inquiry, operator);
        JsonArray result = Ux.toArray(list);
        if (null != inquiry.getProjection()) {
            result = Uarr.create((JsonArray)result).remove(inquiry.getProjection().toArray(new String[0])).to();
        }
        return result;
    }

    private <T> List<T> searchInternal(DSLContext dslContext, Inquiry inquiry, Operator operator) {
        SelectWhereStep started = dslContext.selectFrom(this.vertxDAO.getTable());
        SelectConditionStep conditionStep = null;
        if (null != inquiry.getCriteria()) {
            Condition condition = JooqCond.transform(inquiry.getCriteria().toJson(), operator, this::getColumn);
            conditionStep = started.where(new Condition[]{condition});
        }
        SelectSeekStepN selectStep = null;
        if (null != inquiry.getSorter()) {
            JsonObject sorter = inquiry.getSorter().toJson();
            ArrayList<SortField> orders = new ArrayList<SortField>();
            for (String field : sorter.fieldNames()) {
                boolean asc = sorter.getBoolean(field);
                Field column = this.getColumn(field);
                orders.add(asc ? column.asc() : column.desc());
            }
            selectStep = null == conditionStep ? started.orderBy(orders) : conditionStep.orderBy(orders);
        }
        SelectWithTiesAfterOffsetStep pagerStep = null;
        if (null != inquiry.getPager()) {
            Pager pager = inquiry.getPager();
            pagerStep = null == selectStep && null == conditionStep ? started.offset(pager.getStart()).limit(pager.getSize()) : (null == selectStep ? conditionStep.offset(pager.getStart()).limit(pager.getSize()) : selectStep.offset(pager.getStart()).limit(pager.getSize()));
        }
        if (null != pagerStep) {
            return pagerStep.fetch(this.vertxDAO.mapper());
        }
        if (null != selectStep) {
            return selectStep.fetch(this.vertxDAO.mapper());
        }
        if (null != conditionStep) {
            return conditionStep.fetch(this.vertxDAO.mapper());
        }
        return started.fetch(this.vertxDAO.mapper());
    }

    private <T> List<T> searchInternal(DSLContext dslContext, JsonObject criteria) {
        SelectWhereStep started = dslContext.selectFrom(this.vertxDAO.getTable());
        SelectConditionStep conditionStep = null;
        if (null != criteria) {
            Condition condition = JooqCond.transform(criteria, null, this::getColumn);
            conditionStep = started.where(new Condition[]{condition});
        }
        return started.fetch(this.vertxDAO.mapper());
    }
}

