/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.log.Annal;
import io.vertx.zero.exception.JooqArgumentException;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Operator;
import org.jooq.impl.DSL;

class JooqCond {
    private static final Annal LOGGER = Annal.get(JooqCond.class);
    private static final ConcurrentMap<String, BiFunction<String, Object, Condition>> OPS = new ConcurrentHashMap<String, BiFunction<String, Object, Condition>>(){
        {
            this.put("<", (field, value) -> DSL.field((String)field).lt(value));
            this.put(">", (field, value) -> DSL.field((String)field).gt(value));
            this.put("<=", (field, value) -> DSL.field((String)field).le(value));
            this.put(">=", (field, value) -> DSL.field((String)field).ge(value));
            this.put("=", (field, value) -> DSL.field((String)field).eq(value));
            this.put("<>", (field, value) -> DSL.field((String)field).ne(value));
            this.put("!n", (field, value) -> DSL.field((String)field).isNotNull());
            this.put("n", (field, value) -> DSL.field((String)field).isNull());
            this.put("t", (field, value) -> DSL.field((String)field).isTrue());
            this.put("f", (field, value) -> DSL.field((String)field).isFalse());
            this.put("i", (field, value) -> {
                Collection values = Ut.toCollection((Object)value);
                return DSL.field((String)field).in(values);
            });
            this.put("!i", (field, value) -> {
                Collection values = Ut.toCollection((Object)value);
                return DSL.field((String)field).notIn(values);
            });
            this.put("s", (field, value) -> DSL.field((String)field).startsWith(value));
            this.put("e", (field, value) -> DSL.field((String)field).endsWith(value));
            this.put("c", (field, value) -> DSL.field((String)field).contains(value));
        }
    };
    private static final ConcurrentMap<String, BiFunction<String, Instant, Condition>> DOPS = new ConcurrentHashMap<String, BiFunction<String, Instant, Condition>>(){
        {
            this.put("day", (field, value) -> {
                LocalDate date = Ut.toDate((Instant)value);
                return DSL.field((String)field).between((Object)date.atStartOfDay(), (Object)date.plusDays(1L).atStartOfDay());
            });
            this.put("date", (field, value) -> {
                LocalDate date = Ut.toDate((Instant)value);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                return DSL.field((String)field).eq((Object)date.format(formatter));
            });
        }
    };

    JooqCond() {
    }

    private static String applyField(String field) {
        HashSet<String> keywords = new HashSet<String>(){
            {
                this.add("KEY");
            }
        };
        return keywords.contains(field) ? "`" + field + "`" : field;
    }

    static Condition transform(JsonObject filters, Operator operator, Function<String, Field> fnAnalyze) {
        Condition condition;
        Criteria criteria = Criteria.create((JsonObject)filters);
        if (!Ut.isNil((JsonObject)filters)) {
            LOGGER.info("[ ZERO ] ( Query ) Mode selected {0}, filters raw = {1}", new Object[]{criteria.getMode(), filters});
        }
        if (Inquiry.Mode.LINEAR == criteria.getMode()) {
            JsonObject inputFilters = filters;
            if (null == operator) {
                inputFilters = JooqCond.transformLinear(filters);
                if (inputFilters.containsKey("")) {
                    operator = inputFilters.getBoolean("") != false ? Operator.AND : Operator.OR;
                    inputFilters.remove("");
                }
            } else {
                inputFilters.remove("");
            }
            condition = JooqCond.transformLinear(inputFilters, operator, fnAnalyze);
        } else {
            condition = JooqCond.transformTree(filters, fnAnalyze);
        }
        if (null != condition) {
            LOGGER.info("[ ZERO ] ( Jooq -> Condition ) Parsed result is \ncondition = \n{0}.", new Object[]{condition});
        }
        return condition;
    }

    private static Condition transformTree(JsonObject filters, Function<String, Field> fnAnalyze) {
        Condition condition;
        Operator operator = JooqCond.calcOperator(filters);
        JsonObject cloned = filters.copy();
        cloned.remove("");
        Condition linear = JooqCond.transformLinear(JooqCond.transformLinear(cloned), operator, fnAnalyze);
        List<Condition> tree = JooqCond.transformTreeSet(filters, fnAnalyze);
        if (null != linear) {
            tree.add(linear);
        }
        if (1 == tree.size()) {
            condition = tree.get(0);
        } else {
            condition = tree.get(0);
            for (int idx = 1; idx < tree.size(); ++idx) {
                Condition right = tree.get(idx);
                condition = JooqCond.opCond(condition, right, operator);
            }
        }
        return condition;
    }

    private static List<Condition> transformTreeSet(JsonObject filters, Function<String, Field> fnAnalyze) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        JsonObject tree = filters.copy();
        if (!tree.isEmpty()) {
            for (String field : filters.fieldNames()) {
                if (!Ut.isJObject((Object)tree.getValue(field))) continue;
                conditions.add(JooqCond.transformTree(tree.getJsonObject(field), fnAnalyze));
            }
        }
        return conditions;
    }

    private static JsonObject transformLinear(JsonObject filters) {
        JsonObject linear = filters.copy();
        for (String field : filters.fieldNames()) {
            if (!Ut.isJObject((Object)linear.getValue(field))) continue;
            linear.remove(field);
        }
        return linear;
    }

    private static Operator calcOperator(JsonObject data) {
        Boolean isAnd;
        Operator operator = !data.containsKey("") ? Operator.OR : ((isAnd = Boolean.valueOf(data.getValue("").toString())) != false ? Operator.AND : Operator.OR);
        return operator;
    }

    private static Condition transformLinear(JsonObject filters, Operator operator, Function<String, Field> fnAnalyze) {
        Condition condition = null;
        for (String field : filters.fieldNames()) {
            String key = JooqCond.getKey(field);
            String[] fields = field.split(",");
            String targetField = field.split(",")[0];
            if (null != fnAnalyze) {
                targetField = fnAnalyze.apply(targetField).getName();
            }
            Object value = filters.getValue(field);
            if (3 > fields.length) {
                BiFunction fun = (BiFunction)OPS.get(key);
                Condition item = (Condition)fun.apply(JooqCond.applyField(targetField.trim()), value);
                condition = JooqCond.opCond(condition, item, operator);
                continue;
            }
            if (3 != fields.length) continue;
            Fn.outUp((null == value ? 1 : 0) != 0, (Annal)LOGGER, JooqArgumentException.class, (Object[])new Object[]{UxJooq.class, value});
            Instant instant = filters.getInstant(field);
            Fn.outUp((Instant.class != instant.getClass() ? 1 : 0) != 0, (Annal)LOGGER, JooqArgumentException.class, (Object[])new Object[]{UxJooq.class, instant.getClass()});
            String mode = fields[2];
            BiFunction fun = (BiFunction)DOPS.get(mode);
            Condition item = (Condition)fun.apply(JooqCond.applyField(targetField.trim()), instant);
            condition = JooqCond.opCond(condition, item, operator);
        }
        return condition;
    }

    private static String getKey(String field) {
        if (!field.contains(",")) {
            return "=";
        }
        String opStr = field.split(",")[1];
        return Ut.isNil((String)opStr) ? "=" : opStr.trim().toLowerCase();
    }

    private static Condition opCond(Condition left, Condition right, Operator operator) {
        if (null == left || null == right) {
            if (null == left && null != right) {
                return right;
            }
            return null;
        }
        if (Operator.AND == operator) {
            return left.and(right);
        }
        return left.or(right);
    }
}

