/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.aiki.Async;
import io.vertx.up.aiki.JooqAnalyzer;
import io.vertx.up.aiki.JooqCond;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Operator;

public class JooqReader {
    private final transient VertxDAO vertxDAO;
    private transient JooqAnalyzer analyzer;

    private JooqReader(VertxDAO vertxDAO) {
        this.vertxDAO = vertxDAO;
    }

    static JooqReader create(VertxDAO vertxDAO) {
        return new JooqReader(vertxDAO);
    }

    JooqReader on(JooqAnalyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    <T> Future<T> fetchOneAsync(String field, Object value) {
        return Async.toFuture(this.vertxDAO.fetchOneAsync(this.analyzer.getColumn(field), value));
    }

    <T> Future<T> fetchOneAndAsync(JsonObject filters) {
        Condition condition = JooqCond.transform(filters, Operator.AND, this.analyzer::getColumn);
        return Async.toFuture(this.vertxDAO.fetchOneAsync(condition));
    }

    <T> T fetchOneAnd(JsonObject filters) {
        Condition condition = JooqCond.transform(filters, Operator.AND, this.analyzer::getColumn);
        DSLContext context = JooqInfix.getDSL();
        return this.toResult(context.selectFrom(this.vertxDAO.getTable()).where(new Condition[]{condition}).fetchOne(this.vertxDAO.mapper()));
    }

    <T> Future<T> findByIdAsync(Object id) {
        return Async.toFuture(this.vertxDAO.findByIdAsync(id));
    }

    <T> Future<List<T>> findAllAsync() {
        return Async.toFuture(this.vertxDAO.findAllAsync());
    }

    <T> T fetchOne(String field, Object value) {
        return this.toResult(this.vertxDAO.fetchOne(this.analyzer.getColumn(field), value));
    }

    <T> T findById(Object id) {
        return this.toResult(this.vertxDAO.findById(id));
    }

    <T> List<T> findAll() {
        return this.vertxDAO.findAll();
    }

    Future<Boolean> existsByIdAsync(Object id) {
        return Async.toFuture(this.vertxDAO.existsByIdAsync(id));
    }

    Boolean existsById(Object id) {
        return this.vertxDAO.existsById(id);
    }

    <T> Future<List<T>> fetchAsync(String field, Object value) {
        return Async.toFuture(this.vertxDAO.fetchAsync(this.analyzer.getColumn(field), Arrays.asList(value)));
    }

    <T> Future<List<T>> fetchAsync(Condition condition) {
        return Async.toFuture(this.vertxDAO.fetchAsync(condition));
    }

    <T> Future<List<T>> fetchInAsync(String field, List<Object> values) {
        return Async.toFuture(this.vertxDAO.fetchAsync(this.analyzer.getColumn(field), values));
    }

    <T> List<T> fetch(String field, Object value) {
        return this.vertxDAO.fetch(this.analyzer.getColumn(field), new Object[]{value});
    }

    <T> List<T> fetchIn(String field, List<Object> values) {
        return this.vertxDAO.fetch(this.analyzer.getColumn(field), values.toArray());
    }

    <T> List<T> fetch(Condition condition) {
        DSLContext context = JooqInfix.getDSL();
        return context.selectFrom(this.vertxDAO.getTable()).where(new Condition[]{condition}).fetch(this.vertxDAO.mapper());
    }

    private <T> T toResult(Object value) {
        return (T)(null == value ? null : value);
    }
}

