/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.Async;
import io.vertx.up.aiki.JooqAnalyzer;
import io.vertx.up.aiki.JooqCond;
import io.vertx.up.aiki.JooqReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jooq.Condition;

class JooqWriter {
    private final transient VertxDAO vertxDAO;
    private transient JooqReader reader;
    private transient JooqAnalyzer analyzer;

    private JooqWriter(VertxDAO vertxDAO) {
        this.vertxDAO = vertxDAO;
    }

    static JooqWriter create(VertxDAO vertxDAO) {
        return new JooqWriter(vertxDAO);
    }

    JooqWriter on(JooqAnalyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    JooqWriter on(JooqReader reader) {
        this.reader = reader;
        return this;
    }

    <T> Future<T> insertReturningPrimaryAsync(T entity, Consumer<Long> consumer) {
        CompletableFuture future = this.vertxDAO.insertReturningPrimaryAsync(entity);
        return Async.toFuture(future).compose(id -> {
            if (null != consumer) {
                consumer.accept((Long)id);
            }
            return Future.succeededFuture((Object)entity);
        });
    }

    <T> Future<T> insertAsync(T entity) {
        CompletableFuture future = this.vertxDAO.insertAsync(entity);
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)entity));
    }

    <T> Future<List<T>> insertAsync(List<T> entities) {
        CompletableFuture future = this.vertxDAO.insertAsync(entities);
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)entities));
    }

    <T> T insert(T entity) {
        this.vertxDAO.insert(entity);
        return entity;
    }

    <T> List<T> insert(List<T> entities) {
        this.vertxDAO.insert(entities);
        return entities;
    }

    <T> Future<T> updateAsync(T entity) {
        CompletableFuture future = this.vertxDAO.updateAsync(entity);
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)entity));
    }

    <T> Future<List<T>> updateAsync(List<T> entities) {
        CompletableFuture future = this.vertxDAO.updateAsync(entities);
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)entities));
    }

    <T> T update(T entity) {
        this.vertxDAO.update(entity);
        return entity;
    }

    <T> List<T> update(List<T> entities) {
        this.vertxDAO.update(entities);
        return entities;
    }

    <T> Future<T> deleteAsync(T entity) {
        CompletableFuture future = this.vertxDAO.deleteAsync(Arrays.asList(entity));
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)entity));
    }

    <ID> Future<Boolean> deleteByIdAsync(ID id) {
        CompletableFuture future = this.vertxDAO.deleteByIdAsync(id);
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE));
    }

    <ID> Future<Boolean> deleteByIdAsync(Collection<ID> ids) {
        CompletableFuture future = this.vertxDAO.deleteByIdAsync(ids);
        return Async.toFuture(future).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE));
    }

    <T, ID> Future<Boolean> deleteAsync(JsonObject filters, String pojo) {
        Condition condition = JooqCond.transform(filters, null, this.analyzer::getColumn);
        CompletableFuture deleted = this.vertxDAO.deleteExecAsync(condition);
        return Async.toFuture(deleted).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE));
    }

    <T> T delete(T entity) {
        this.vertxDAO.delete(entity);
        return entity;
    }

    <ID> Boolean deleteById(ID id) {
        this.vertxDAO.deleteById(new Object[]{id});
        return Boolean.TRUE;
    }

    <ID> Boolean deleteById(Collection<ID> ids) {
        this.vertxDAO.deleteById(ids);
        return Boolean.TRUE;
    }

    <T, ID> Boolean delete(JsonObject filters, String pojo) {
        Condition condition = JooqCond.transform(filters, null, this.analyzer::getColumn);
        List result = this.reader.fetch(condition);
        result.stream().map(item -> this.delete(item));
        return Boolean.TRUE;
    }

    <T> Future<T> saveAsync(Object id, Function<T, T> copyFun) {
        return this.reader.findByIdAsync(id).compose(old -> this.updateAsync(copyFun.apply(old)));
    }

    <T> T save(Object id, Function<T, T> copyFun) {
        Object old = this.reader.findById(id);
        return copyFun.apply(old);
    }
}

