/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.up.aiki.Async;
import io.vertx.up.aiki.Atomic;
import io.vertx.up.aiki.Cache;
import io.vertx.up.aiki.Calculator;
import io.vertx.up.aiki.Debug;
import io.vertx.up.aiki.Fluctuate;
import io.vertx.up.aiki.From;
import io.vertx.up.aiki.Functions;
import io.vertx.up.aiki.In;
import io.vertx.up.aiki.Pagination;
import io.vertx.up.aiki.Query;
import io.vertx.up.aiki.To;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.aiki.UxJwt;
import io.vertx.up.aiki.UxMongo;
import io.vertx.up.aiki.UxPool;
import io.vertx.up.aiki.UxRpc;
import io.vertx.up.aiki.Web;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.exception.WebException;
import io.zero.epic.Ut;
import io.zero.epic.container.RxHod;
import io.zero.epic.fn.Actuator;
import io.zero.epic.fn.Fn;
import io.zero.epic.fn.wait.Log;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooq.Condition;

public final class Ux {
    public static Log log(Class<?> clazz) {
        return Log.create(null == clazz ? Ux.class : clazz);
    }

    public static void debug(Object ... objects) {
        Debug.monitor(objects);
    }

    public static <T> Future<T> debug(T item) {
        Fn.safeNull(() -> Debug.monitor(item), (Object[])new Object[]{item});
        return Future.succeededFuture(item);
    }

    public static void timer(Class<?> clazz, Actuator actuator) {
        Debug.timer(clazz, actuator);
    }

    public static <T> T timer(Class<?> clazz, Supplier<T> supplier) {
        return Debug.timer(clazz, supplier);
    }

    public static JsonObject toPagerJson(int page, int size) {
        return Pagination.toPager(page, size).toJson();
    }

    public static Pager toPager(int page, int size) {
        return Pagination.toPager(page, size);
    }

    public static Pager toPager(JsonObject data) {
        return Pagination.toPager(data);
    }

    public static Sorter toSorter(String field, boolean asc) {
        return Pagination.toSorter(field, asc);
    }

    public static Sorter toSorter(String field, int mode) {
        return Pagination.toSorter(field, mode);
    }

    public static <T> JsonObject toJson(T entity) {
        return To.toJson(entity, "");
    }

    public static <T> JsonObject toJson(T entity, String pojo) {
        return To.toJson(entity, pojo);
    }

    public static JsonObject toFilters(String[] columns, Supplier<Object> ... supplier) {
        return To.toFilters(columns, supplier);
    }

    public static <T> T fromJson(JsonObject data, Class<T> clazz) {
        return From.fromJson(data, clazz, "");
    }

    public static <T> T fromJson(JsonObject data, Class<T> clazz, String pojo) {
        return From.fromJson(data, clazz, pojo);
    }

    public static JsonObject fromJson(JsonObject data, String pojo) {
        return From.fromJson(data, pojo);
    }

    public static <T> JsonObject toJsonFun(T entity, Function<JsonObject, JsonObject> convert) {
        return To.toJson(entity, convert);
    }

    public static <T> JsonObject toGroup(JsonArray array, String field) {
        return Calculator.groupBy(array, field);
    }

    public static Future<JsonObject> thenGroup(JsonArray array, String field) {
        return Future.succeededFuture((Object)Calculator.groupBy(array, field));
    }

    public static void appendJson(JsonObject target, JsonObject source) {
        Calculator.appendJson(target, source);
    }

    public static WebException toError(Class<? extends WebException> clazz, Object ... args) {
        return To.toError(clazz, args);
    }

    public static WebException toError(Class<?> clazz, Throwable error) {
        return To.toError(clazz, error);
    }

    public static <T> JsonArray toArray(List<T> list) {
        return To.toArray(list, "");
    }

    public static <T> JsonArray toArray(List<T> list, String pojo) {
        return To.toArray(list, pojo);
    }

    public static <T> JsonArray toArrayFun(List<T> list, Function<JsonObject, JsonObject> convert) {
        return To.toArray(list, convert);
    }

    public static BiConsumer<JsonArray, Object> fnCollectJArray() {
        return Functions.fnCollectJArray();
    }

    public static <T> Future<T> toFuture(T entity) {
        return To.toFuture(entity);
    }

    public static <T, R> Future<R> toFuture(T entity, Supplier<R> defaultFun, Function<T, R> actualFun) {
        return null == entity ? Future.succeededFuture(defaultFun.get()) : Future.succeededFuture(actualFun.apply(entity));
    }

    public static <T> Future<T> toFuture(Supplier<Future<T>> caseLine) {
        return Fn.future(caseLine);
    }

    public static <T> Future<T> toFuture(Actuator executor, Supplier<Future<T>> caseLine) {
        return Fn.future((Actuator)executor, caseLine);
    }

    public static <T> Envelop to(List<T> list) {
        return Envelop.success(Ux.toArray(list));
    }

    public static Envelop to(Class<? extends WebException> clazz, Object ... args) {
        return To.toEnvelop(clazz, args);
    }

    public static <T> Envelop to(T entity) {
        return To.toEnvelop(entity);
    }

    public static <T> Envelop to(T entity, WebException error) {
        return To.toEnvelop(entity, error);
    }

    public static Envelop toOne(JsonArray array) {
        return Envelop.success(To.toUnique(array, ""));
    }

    public static <T> JsonObject toUnique(List<T> list) {
        return To.toUnique(Ux.toArray(list), "");
    }

    public static <T> JsonObject toUnique(List<T> list, String pojo) {
        return To.toUnique(Ux.toArray(list), pojo);
    }

    public static <T> JsonObject toUnique(JsonArray array) {
        return To.toUnique(array, "");
    }

    public static String getUserID(Message<Envelop> message, String field) {
        return In.requestUser(message, field);
    }

    public static String getUserID(Envelop envelop, String field) {
        return In.requestUser(envelop, field);
    }

    public static UUID getUserUUID(Message<Envelop> message, String field) {
        return UUID.fromString(Ux.getUserID(message, field));
    }

    public static UUID getUserUUID(Envelop envelop, String field) {
        return UUID.fromString(Ux.getUserID(envelop, field));
    }

    public static String getToken(String token, String field) {
        return In.requestTokenData(token, field);
    }

    public static Object getSession(Message<Envelop> message, String field) {
        return In.requestSession(message, field);
    }

    public static Object getSession(Envelop envelop, String field) {
        return In.requestSession(envelop, field);
    }

    public static JsonArray fillSerial(JsonArray items, JsonArray serials) {
        return In.assignValue(items, serials, "serial", false);
    }

    public static JsonArray assignSerial(JsonArray items, JsonArray serials) {
        return In.assignValue(items, serials, "serial", true);
    }

    public static JsonArray fillField(JsonArray items, JsonArray targets, String field) {
        return In.assignValue(items, targets, field, false);
    }

    public static JsonArray assignField(JsonArray items, JsonArray targets, String field) {
        return In.assignValue(items, targets, field, true);
    }

    public static void assignAuditor(Object reference, boolean isUpdate) {
        In.assignAuditor(reference, isUpdate);
    }

    public static Future<JsonObject> fnRpc(JsonArray array) {
        return UxRpc.fnRpc(array);
    }

    public static Future<JsonArray> fnRpc(JsonObject data) {
        return UxRpc.fnRpc(data);
    }

    public static <T> Future<JsonObject> fnJObject(T item) {
        return Ux.thenJsonOne(item, "");
    }

    public static <T> Future<JsonArray> fnJArray(List<T> item) {
        return Ux.thenJsonMore(item, "");
    }

    public static <T> Function<T, Future<JsonObject>> fnJObject(String pojo) {
        return item -> Ux.thenJsonOne(item, pojo);
    }

    public static <T> Function<List<T>, Future<JsonArray>> fnJArray(String pojo) {
        return list -> Ux.thenJsonMore(list, pojo);
    }

    public static <T> Handler<AsyncResult<T>> toHandler(Message<Envelop> message) {
        return Web.toHandler(message);
    }

    public static <T> Handler<AsyncResult<Boolean>> toHandler(Message<Envelop> message, JsonObject data) {
        return Web.toHandler(message, data);
    }

    public static <T> Future<JsonObject> thenRpc(String name, String address, JsonObject params) {
        return UxRpc.thenRpc(name, address, params);
    }

    public static <T> Future<JsonObject> thenRpc(String name, String address, String field, Object value) {
        return UxRpc.thenRpc(name, address, new JsonObject().put(field, value));
    }

    public static <T> Future<Envelop> then(T entity) {
        return Future.succeededFuture((Object)Ux.to(entity));
    }

    public static Future<JsonObject> thenBool(Boolean result) {
        return Future.succeededFuture((Object)new JsonObject().put("RESULT", result));
    }

    public static <T> Future<JsonArray> thenJsonMore(List<T> list) {
        return Future.succeededFuture((Object)To.toArray(list, ""));
    }

    public static <T> Future<JsonArray> thenJsonMore(List<T> list, String pojo) {
        return Future.succeededFuture((Object)To.toArray(list, pojo));
    }

    public static <T> Future<JsonObject> thenJsonOne(List<T> list, String pojo) {
        return Future.succeededFuture((Object)To.toUnique(new JsonArray(list), pojo));
    }

    public static <T> Future<JsonObject> thenJsonOne(T entity, String pojo) {
        return Future.succeededFuture((Object)To.toJson(entity, pojo));
    }

    public static <T> Future<JsonObject> thenUpsert(T entity, Supplier<Future<JsonObject>> supplier) {
        return Async.toUpsertFuture(entity, "", supplier, null);
    }

    public static <T> Future<JsonObject> thenUpsert(T entity, Supplier<Future<JsonObject>> supplier, Function<JsonObject, JsonObject> updateFun) {
        return Async.toUpsertFuture(entity, "", supplier, updateFun);
    }

    public static <T> Future<JsonObject> thenUpsert(T entity, String pojo, Supplier<Future<JsonObject>> supplier) {
        return Async.toUpsertFuture(entity, pojo, supplier, null);
    }

    public static <T> Future<JsonObject> thenUpsert(T entity, String pojo, Supplier<Future<JsonObject>> supplier, Function<JsonObject, JsonObject> updateFun) {
        return Async.toUpsertFuture(entity, pojo, supplier, updateFun);
    }

    public static <T> Future<Envelop> thenMore(List<T> list, String pojo) {
        return Future.succeededFuture((Object)Envelop.success(To.toArray(list, pojo)));
    }

    public static <T> Future<Envelop> thenOne(T entity, String pojo) {
        return Future.succeededFuture((Object)Envelop.success(To.toJson(entity, pojo)));
    }

    public static <T> Future<T> thenGeneric(Consumer<Future<T>> consumer) {
        return Fn.thenGeneric(consumer);
    }

    public static <T> Future<T> thenGeneric(Object result, Future<T> future, Throwable ex) {
        return Fn.thenGeneric((Object)result, future, (Throwable)ex);
    }

    public static <F, S, T> Future<List<T>> thenParallel(Future<List<F>> source, Function<F, Future<S>> generateFun, BiFunction<F, S, T> mergeFun) {
        return Fluctuate.thenParallel(source, generateFun, mergeFun);
    }

    public static Future<JsonArray> thenParallelArray(Future<JsonArray> source, Function<JsonObject, Future<JsonObject>> generateFun, BinaryOperator<JsonObject> operatorFun) {
        return Fluctuate.thenParallelArray(source, generateFun, operatorFun);
    }

    public static Future<JsonObject> thenParallelArray(Future<JsonArray> ... sources) {
        return Fluctuate.thenParallelArray(sources);
    }

    public static Future<JsonObject> thenParallelJson(Future<JsonObject> ... sources) {
        return Fluctuate.thenParallelJson(sources);
    }

    public static Future<JsonObject> thenParallelJson(Future<JsonObject> source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return Fluctuate.thenParallelJson(source, generateFun, operatorFun);
    }

    public static Future<JsonObject> thenParallelJson(JsonObject source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return Fluctuate.thenParallelJson((Future<JsonObject>)Future.succeededFuture((Object)source), generateFun, operatorFun);
    }

    public static Future<JsonArray> thenScatterJson(Future<JsonArray> source, Function<JsonObject, Future<JsonArray>> generateFun, BiFunction<JsonObject, JsonArray, JsonObject> mergeFun) {
        return Fluctuate.thenScatterJson(source, generateFun, mergeFun);
    }

    public static <F, S, T> Future<T> thenComposite(Future<F> source, BiFunction<F, List<S>, T> mergeFun, Supplier<Future<S>> ... suppliers) {
        return Fluctuate.thenComposite(source, mergeFun, suppliers);
    }

    public static Future<JsonArray> thenComposite(List<Future<JsonObject>> futures) {
        return Fluctuate.thenComposite(futures);
    }

    public static <T, I> Future<Set<T>> thenSet(List<I> data, Function<I, Future<T>> fun) {
        return Fluctuate.thenSet(data, fun);
    }

    public static <F, S, T> Future<T> thenComposite(Future<F> source, BiFunction<F, List<S>, T> mergeFun, Function<F, Future<S>> ... functions) {
        return Fluctuate.thenComposite(source, mergeFun, functions);
    }

    public static <T, F, R> Future<R> thenOtherwise(Future<Boolean> condition, Supplier<Future<T>> trueFuture, Function<T, R> trueFun, Supplier<Future<F>> falseFuture, Function<F, R> falseFun) {
        return Fluctuate.thenOtherwise(condition, trueFuture, trueFun, falseFuture, falseFun);
    }

    public static <T, R> Future<R> thenError(Future<Boolean> condition, Supplier<Future<T>> trueFuture, Function<T, R> trueFun, Class<? extends WebException> clazz, Object ... args) {
        return Fluctuate.thenOtherwise(condition, trueFuture, trueFun, clazz, args);
    }

    public static Future<JsonObject> thenError(Future<Boolean> condition, Supplier<Future<JsonObject>> trueFuture, Class<? extends WebException> clazz, Object ... args) {
        return Fluctuate.thenOtherwise(condition, trueFuture, (T item) -> item, clazz, args);
    }

    public static <T> Future<T> thenError(Class<? extends WebException> clazz, Object ... args) {
        return Fluctuate.thenError(clazz, args);
    }

    public static <T, R> Future<R> thenTrue(Future<Boolean> condition, Supplier<Future<T>> trueFuture, Function<T, R> trueFun) {
        return Fluctuate.thenOtherwise(condition, trueFuture, trueFun, null, new Object[0]);
    }

    public static JsonArray getArray(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, JsonArray.class);
    }

    public static JsonArray getArray(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, JsonArray.class);
    }

    public static JsonArray getArray(Message<Envelop> message) {
        return In.request(message, (Integer)0, JsonArray.class);
    }

    public static JsonArray getArray(Envelop envelop) {
        return In.request(envelop, (Integer)0, JsonArray.class);
    }

    public static JsonArray getArray1(Message<Envelop> message) {
        return In.request(message, (Integer)1, JsonArray.class);
    }

    public static JsonArray getArray1(Envelop envelop) {
        return In.request(envelop, (Integer)1, JsonArray.class);
    }

    public static JsonArray getArray2(Message<Envelop> message) {
        return In.request(message, (Integer)2, JsonArray.class);
    }

    public static JsonArray getArray2(Envelop envelop) {
        return In.request(envelop, (Integer)2, JsonArray.class);
    }

    public static JsonArray getArray3(Message<Envelop> message) {
        return In.request(message, (Integer)3, JsonArray.class);
    }

    public static JsonArray getArray3(Envelop envelop) {
        return In.request(envelop, (Integer)3, JsonArray.class);
    }

    public static String getString(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, String.class);
    }

    public static String getString(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, String.class);
    }

    public static String getString(Message<Envelop> message) {
        return In.request(message, (Integer)0, String.class);
    }

    public static String getString(Envelop envelop) {
        return In.request(envelop, (Integer)0, String.class);
    }

    public static String getString1(Message<Envelop> message) {
        return In.request(message, (Integer)1, String.class);
    }

    public static String getString1(Envelop envelop) {
        return In.request(envelop, (Integer)1, String.class);
    }

    public static String getString2(Message<Envelop> message) {
        return In.request(message, (Integer)2, String.class);
    }

    public static String getString2(Envelop envelop) {
        return In.request(envelop, (Integer)2, String.class);
    }

    public static String getString3(Message<Envelop> message) {
        return In.request(message, (Integer)3, String.class);
    }

    public static String getString3(Envelop envelop) {
        return In.request(envelop, (Integer)3, String.class);
    }

    public static JsonObject getJson(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, JsonObject.class);
    }

    public static JsonObject getJson(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, JsonObject.class);
    }

    public static JsonObject getJson(Message<Envelop> message) {
        return In.request(message, (Integer)0, JsonObject.class);
    }

    public static <T> T fromEnvelop(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson(envelop), clazz, pojo);
    }

    public static JsonObject fromEnvelop(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson(envelop), pojo);
    }

    public static JsonObject getJson(Envelop envelop) {
        return In.request(envelop, (Integer)0, JsonObject.class);
    }

    public static Inquiry getInquiry(JsonObject envelop) {
        return Query.getInquiry(envelop, "");
    }

    public static Inquiry getInquiry(JsonObject envelop, String pojo) {
        return Query.getInquiry(envelop, pojo);
    }

    public static JsonObject getJson1(Message<Envelop> message) {
        return In.request(message, (Integer)1, JsonObject.class);
    }

    public static <T> T fromEnvelop1(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson1(envelop), clazz, pojo);
    }

    public static JsonObject fromEnvelop1(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson1(envelop), pojo);
    }

    public static JsonObject getJson1(Envelop envelop) {
        return In.request(envelop, (Integer)1, JsonObject.class);
    }

    public static JsonObject getJson2(Message<Envelop> message) {
        return In.request(message, (Integer)2, JsonObject.class);
    }

    public static JsonObject getJson2(Envelop envelop) {
        return In.request(envelop, (Integer)2, JsonObject.class);
    }

    public static JsonObject fromEnvelop2(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson2(envelop), pojo);
    }

    public static <T> T fromEnvelop2(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson2(envelop), clazz, pojo);
    }

    public static JsonObject getJson3(Message<Envelop> message) {
        return In.request(message, (Integer)3, JsonObject.class);
    }

    public static JsonObject getJson3(Envelop envelop) {
        return In.request(envelop, (Integer)3, JsonObject.class);
    }

    public static JsonObject fromEnvelop3(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson3(envelop), pojo);
    }

    public static <T> T fromEnvelop3(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson3(envelop), clazz, pojo);
    }

    public static Integer getInteger(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, Integer.class);
    }

    public static Integer getInteger(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Integer.class);
    }

    public static Integer getInteger(Message<Envelop> message) {
        return In.request(message, (Integer)0, Integer.class);
    }

    public static Integer getInteger(Envelop envelop) {
        return In.request(envelop, (Integer)0, Integer.class);
    }

    public static Integer getInteger1(Message<Envelop> message) {
        return In.request(message, (Integer)1, Integer.class);
    }

    public static Integer getInteger1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Integer.class);
    }

    public static Integer getInteger2(Message<Envelop> message) {
        return In.request(message, (Integer)2, Integer.class);
    }

    public static Integer getInteger2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Integer.class);
    }

    public static Integer getInteger3(Message<Envelop> message) {
        return In.request(message, (Integer)3, Integer.class);
    }

    public static Integer getInteger3(Envelop envelop) {
        return In.request(envelop, (Integer)3, Integer.class);
    }

    public static Long getLong(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, Long.class);
    }

    public static Long getLong(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Long.class);
    }

    public static Long getLong(Message<Envelop> message) {
        return In.request(message, (Integer)0, Long.class);
    }

    public static Long getLong(Envelop envelop) {
        return In.request(envelop, (Integer)0, Long.class);
    }

    public static Long getLong1(Message<Envelop> message) {
        return In.request(message, (Integer)1, Long.class);
    }

    public static Long getLong1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Long.class);
    }

    public static Long getLong2(Message<Envelop> message) {
        return In.request(message, (Integer)2, Long.class);
    }

    public static Long getLong2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Long.class);
    }

    public static Long getLong3(Message<Envelop> message) {
        return In.request(message, (Integer)3, Long.class);
    }

    public static Long getLong3(Envelop envelop) {
        return In.request(envelop, (Integer)3, Long.class);
    }

    public static <T> T getT(Message<Envelop> message, int index, Class<T> clazz) {
        return In.request(message, (Integer)index, clazz);
    }

    public static <T> T getT(Envelop envelop, int index, Class<T> clazz) {
        return In.request(envelop, (Integer)index, clazz);
    }

    public static <T> T getT(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)0, clazz);
    }

    public static <T> T getT(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)0, clazz);
    }

    public static <T> T getT1(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)1, clazz);
    }

    public static <T> T getT1(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)1, clazz);
    }

    public static <T> T getT2(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)2, clazz);
    }

    public static <T> T getT2(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)2, clazz);
    }

    public static <T> T getT3(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)3, clazz);
    }

    public static <T> T getT3(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)3, clazz);
    }

    public static JsonObject getBody(Message<Envelop> message) {
        return In.request(message, JsonObject.class);
    }

    public static JsonObject getBody(Envelop envelop) {
        return In.request(envelop, JsonObject.class);
    }

    public static <T> T getBodyT(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, clazz);
    }

    public static <T> T getBodyT(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, clazz);
    }

    public static <E, T> Future<E> rxContainer(RxHod container, E entity) {
        return Functions.fnSupplier(container, entity, null);
    }

    public static <E, T> Future<E> rxContainer(RxHod container, E entity, Supplier<T> supplier) {
        return Functions.fnSupplier(container, entity, supplier);
    }

    public static <E, T> Future<E> rxContainer(RxHod container, E entity, Consumer<T> consumer) {
        return Functions.fnConsumer(container, entity, consumer);
    }

    public static <E, T> Future<E> rxContainer(RxHod container, E entity, Function<T, E> function) {
        return Functions.fnConsumer(container, entity, item -> function.apply(item));
    }

    public static <E, T> Future<E> rxContainer(RxHod container, E entity, T target) {
        return Functions.fnSupplier(container, entity, () -> target);
    }

    public static Function<JsonObject, Future<JsonObject>> atomJoin(String field, JsonObject to) {
        return Atomic.joinTo(to, field);
    }

    public static Function<JsonObject, Future<JsonObject>> atomJoin(JsonObject from, String field) {
        return Atomic.joinFrom(from, field);
    }

    public static Condition condition(JsonObject filters) {
        return UxJooq.transform(filters);
    }

    public static Condition condition(Criteria criteria) {
        return UxJooq.transform(criteria.toJson());
    }

    public static class Mongo {
        public static JsonObject termIn(JsonObject filter, String field, JsonArray values) {
            return UxMongo.termIn(filter, field, values);
        }

        public static JsonObject termLike(JsonObject filter, String field, String value) {
            return UxMongo.termLike(filter, field, value);
        }

        public static Future<Boolean> missing(String collection, JsonObject filter) {
            return UxMongo.missing(collection, filter);
        }

        public static Future<Boolean> existing(String collection, JsonObject filter) {
            return UxMongo.existing(collection, filter);
        }

        public static Future<JsonObject> insert(String collection, JsonObject data) {
            return UxMongo.insert(collection, data);
        }

        public static Future<JsonObject> findOne(String collection, JsonObject filter) {
            return UxMongo.findOne(collection, filter);
        }

        public static Future<JsonObject> findOne(String collection, JsonObject filter, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
            return UxMongo.findOne(collection, filter, joinedCollection, joinedKey, additional, operatorFun);
        }

        public static Future<JsonObject> findOneAndReplace(String collection, JsonObject filter, String field, Object value) {
            return UxMongo.findOneAndReplace(collection, filter, new JsonObject().put(field, value));
        }

        public static Future<JsonObject> findOneAndReplace(String collection, JsonObject filter, JsonObject data) {
            return UxMongo.findOneAndReplace(collection, filter, data);
        }

        public static Future<Long> removeDocument(String collection, JsonObject filter) {
            return UxMongo.removeDocument(collection, filter);
        }

        public static Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options) {
            return UxMongo.findWithOptions(collection, filter, options);
        }

        public static Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
            return UxMongo.findWithOptions(collection, filter, options, joinedCollection, joinedKey, additional, operatorFun);
        }

        public static Future<JsonArray> find(String collection, JsonObject filter) {
            return UxMongo.findWithOptions(collection, filter, new FindOptions());
        }
    }

    public static class Jwt {
        public static String token(JsonObject claims) {
            return UxJwt.generate(claims, new JWTOptions());
        }

        public static String token(JsonObject claims, Function<String, Buffer> funcBuffer) {
            return UxJwt.generate(claims, new JWTOptions(), funcBuffer);
        }

        public static JsonObject extract(JsonObject vertxToken) {
            return UxJwt.extract(vertxToken.getString("jwt"));
        }

        public static JsonObject extract(String token) {
            return UxJwt.extract(token);
        }

        public static JsonObject extract(String token, JsonObject config) {
            return UxJwt.extract(token, config);
        }

        public static JWT create(JWTAuthOptions config) {
            return UxJwt.create(new JWTAuthOptions(config), Ut::ioBuffer);
        }

        public static JWT create(JsonObject config) {
            return UxJwt.create(new JWTAuthOptions(config), Ut::ioBuffer);
        }

        public static JWT create(JWTAuthOptions config, Function<String, Buffer> funcBuffer) {
            return UxJwt.create(config, funcBuffer);
        }

        public static JWT create(JsonObject config, Function<String, Buffer> funcBuffer) {
            return UxJwt.create(new JWTAuthOptions(config), funcBuffer);
        }
    }

    public static class Pool {
        public static UxPool on(String name) {
            return (UxPool)Fn.pool(Cache.POOL, (Object)name, () -> new UxPool(name));
        }

        public static UxPool on() {
            return new UxPool();
        }
    }

    public static class Jooq {
        public static UxJooq on(Class<?> clazz) {
            return (UxJooq)Fn.pool(Cache.JOOQ, clazz, () -> new UxJooq(clazz));
        }

        public static UxJooq on(Class<?> clazz, VertxDAO vertxDAO) {
            return (UxJooq)Fn.pool(Cache.JOOQ, clazz, () -> new UxJooq(clazz, vertxDAO));
        }
    }
}

